package com.xunlei.niux.data.clientgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.clientgame.vo.PayDetail;
import com.xunlei.niux.data.clientgame.vo.PayDetailOK;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.sql.DataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PayDetailOKDaoImpl extends BaseDaoImpl implements IPayDetailOKDao {
	
	private static Logger log = Logger.getLogger(PayDetailOKDaoImpl.class);
	@Override
	public Sheet<PayDetailOK> query(PayDetailOK data, PagedFliper fliper) {
		List<Object> paramList=new ArrayList<Object>();
		String sql = "select * from paydetailok ";
		String rowsql = "select count(1) from paydetailok ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");

		if(StringUtils.isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid=?");
			paramList.add(data.getGameid());
		}
		
		if(StringUtils.isNotEmpty(data.getChargetype())){
			wheresql.append(" And ChargeType=?");
			paramList.add(data.getChargetype());
		}
		
		if(StringUtils.isNotEmpty(data.getBankno())){
			wheresql.append(" And BankNo=?");
			paramList.add(data.getBankno());
		}
		
		if(StringUtils.isNotEmpty(data.getFromusername())){
			wheresql.append(" And FromUserName=?");
			paramList.add(data.getFromusername());
		}
		
		if(StringUtils.isNotEmpty(data.getFrominneruserid())){
			wheresql.append(" And FromInnerUserid=?");
			paramList.add(data.getFrominneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName=?");
			paramList.add(data.getTousername());
		}
		
		if(StringUtils.isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid=?");
			paramList.add(data.getToinneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid=?");
			paramList.add(data.getServerid());
		}
		
		if(StringUtils.isNotEmpty(data.getServername())){
			wheresql.append(" And ServerName=?");
			paramList.add(data.getServername());
		}
		
		if(StringUtils.isNotEmpty(data.getRoleid())){
			wheresql.append(" And RoleId=?");
			paramList.add(data.getRoleid());
		}
		
		if(StringUtils.isNotEmpty(data.getRolename())){
			wheresql.append(" And RoleName=?");
			paramList.add(data.getRolename());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderid())){
			wheresql.append(" And OrderId=?");
			paramList.add(data.getOrderid());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderidstatus())){
			wheresql.append(" And OrderIdStatus=?");
			paramList.add(data.getOrderidstatus());
		}

		if(StringUtils.isNotEmpty(data.getFromOrderTime())){
			String fromOrderTime = data.getFromOrderTime() + " 00:00:00";
			wheresql.append(" And ChargeSuccessTime>=?");
			paramList.add(fromOrderTime);
		}
		
		if(StringUtils.isNotEmpty(data.getToOrderTime())){
			String toOrderTime = data.getToOrderTime() + " 23:59:59";
			wheresql.append(" And ChargeSuccessTime<=?");
			paramList.add(toOrderTime);
		}
		if(StringUtils.isNotEmpty(data.getFromSuccessTme())){
			String fromSuccessTme = data.getFromSuccessTme() + " 00:00:00";
			wheresql.append(" And SuccessTime>=?");
			paramList.add(fromSuccessTme);
		}
		
		if(StringUtils.isNotEmpty(data.getToSuccessTime())){
			String toSuccessTime = data.getToSuccessTime() + " 23:59:59";
			wheresql.append(" And successTime<=?");
			paramList.add(toSuccessTime);
		}
		if(StringUtils.isNotEmpty(data.getReferfrom())){
			wheresql.append(" And Referfrom=?");
			paramList.add(data.getReferfrom());
		}
		if(StringUtils.isNotEmpty(data.getNiuxactno())){
			wheresql.append(" And Niuxactno=?");
			paramList.add(data.getNiuxactno());
		}
		if("1".equals(data.getExcepttest())){
			wheresql.append(" And ToUserName<>'youxiceshi' And ToUserName<> 'fontong'  and  ToUserName<> 'niuxfontong'");
		}else if("2".equals(data.getExcepttest())){
			wheresql.append(" And (ToUserName='youxiceshi' Or ToUserName = 'fontong' or ToUserName='niuxfontong') ");
		}
		if(StringUtils.isNotEmpty(data.getGiftFlag())){
			wheresql.append(" And GiftFlag=?");
			paramList.add(data.getGiftFlag());
		}
		
		rowsql = rowsql + wheresql.toString();
		log.info("rowsql:"+rowsql);
		int rowcount = this.getJdbcTemplate().queryForInt(rowsql, paramList.toArray());
		if(rowcount<=0){
			return Sheet.EMPTY;
		}
		
		
		sql += wheresql.toString();
		
		if (fliper != null) {
			if(StringUtils.isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<PayDetailOK>(rowcount,this.executeQuery(PayDetailOK.class, sql, paramList));
	}

	@Override
	public PayDetailOK querySum(PayDetailOK data) {
		List<Object> paramList=new ArrayList<Object>();
		final PayDetailOK result = new PayDetailOK();
		String sql = "select sum(TotalMoney) as price,sum(payMondey) as payprice,sum(vouchersMoney) as voucherprice from paydetailok ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");

		if(StringUtils.isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid=?");
			paramList.add(data.getGameid());
		}
		
		if(StringUtils.isNotEmpty(data.getChargetype())){
			wheresql.append(" And ChargeType=?");
			paramList.add(data.getChargetype());
		}
		
		if(StringUtils.isNotEmpty(data.getBankno())){
			wheresql.append(" And BankNo=?");
			paramList.add(data.getBankno());
		}
		
		if(StringUtils.isNotEmpty(data.getFromusername())){
			wheresql.append(" And FromUserName=?");
			paramList.add(data.getFromusername());
		}
		
		if(StringUtils.isNotEmpty(data.getFrominneruserid())){
			wheresql.append(" And FromInnerUserid=?");
			paramList.add(data.getFrominneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName=?");
			paramList.add(data.getTousername());
		}
		
		if(StringUtils.isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid=?");
			paramList.add(data.getToinneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid=?");
			paramList.add(data.getServerid());
		}
		
		if(StringUtils.isNotEmpty(data.getServername())){
			wheresql.append(" And ServerName=?");
			paramList.add(data.getServername());
		}
		
		if(StringUtils.isNotEmpty(data.getRoleid())){
			wheresql.append(" And RoleId=?");
			paramList.add(data.getRoleid());
		}
		
		if(StringUtils.isNotEmpty(data.getRolename())){
			wheresql.append(" And RoleName=?");
			paramList.add(data.getRolename());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderid())){
			wheresql.append(" And OrderId=?");
			paramList.add(data.getOrderid());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderidstatus())){
			wheresql.append(" And OrderIdStatus=?");
			paramList.add(data.getOrderidstatus());
		}

		if(StringUtils.isNotEmpty(data.getFromOrderTime())){
			String fromOrderTime = data.getFromOrderTime() + " 00:00:00";
			wheresql.append(" And ChargeSuccessTime>=?");
			paramList.add(fromOrderTime);
		}
		
		if(StringUtils.isNotEmpty(data.getToOrderTime())){
			String toOrderTime = data.getToOrderTime() + " 23:59:59";
			wheresql.append(" And ChargeSuccessTime<=?");
			paramList.add(toOrderTime);
		}
		if(StringUtils.isNotEmpty(data.getFromSuccessTme())){
			String fromSuccessTme = data.getFromSuccessTme() + " 00:00:00";
			wheresql.append(" And SuccessTime>=?");
			paramList.add(fromSuccessTme);
		}
		
		if(StringUtils.isNotEmpty(data.getToSuccessTime())){
			String toSuccessTime = data.getToSuccessTime() + " 23:59:59";
			wheresql.append(" And successTime<=?");
			paramList.add(toSuccessTime);
		}
		if(StringUtils.isNotEmpty(data.getReferfrom())){
			wheresql.append(" And Referfrom=?");
			paramList.add(data.getReferfrom());
		}
		if(StringUtils.isNotEmpty(data.getNiuxactno())){
			wheresql.append(" And Niuxactno=?");
			paramList.add(data.getNiuxactno());
		}
		if("1".equals(data.getExcepttest())){
			wheresql.append(" And ToUserName<>'youxiceshi' And ToUserName<> 'fontong'  and  ToUserName<> 'niuxfontong'");
		}else if("2".equals(data.getExcepttest())){
			wheresql.append(" And (ToUserName='youxiceshi' Or ToUserName = 'fontong' or ToUserName='niuxfontong') ");
		}
		if(StringUtils.isNotEmpty(data.getGiftFlag())){
			wheresql.append(" And GiftFlag=?");
			paramList.add(data.getGiftFlag());
		}
		
		log.info("sql:"+sql + wheresql.toString());
		//double money = this.getSingleDouble(sql + wheresql.toString());
		Map resultMap = this.getJdbcTemplate().queryForMap(sql + wheresql.toString());
		if(resultMap != null){
			String price = resultMap.get("price")==null?"0.0":resultMap.get("price").toString();
			String payprice = resultMap.get("payprice")==null?"0.0":resultMap.get("payprice").toString();
			String voucherprice = resultMap.get("voucherprice")==null?"0.0":resultMap.get("voucherprice").toString();
			result.setTotalmoney(price);
			result.setPayMondey(new Double(payprice==null?"0":payprice));
			result.setVouchersMoney(new Double(voucherprice==null?"0":voucherprice));
			//result.setPayMondey(new Double(price)-result.getVouchersMoney());
		}else{
			result.setPayMondey(new Double("0.0"));
			result.setVouchersMoney(new Double("0.0"));
			result.setPayMondey(new Double("0.0"));
		}
		return result;
	}

	@Override
	public void update(PayDetailOK data){
		this.update(data);
	}

	@Override
	public void insert(PayDetailOK data) {
		this.insert(data);
	}
	
	@Override
	public PayDetailOK find(PayDetailOK data){
		List<Object> paramList=new ArrayList<Object>();
		String sql = "select * from paydetailok ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");

		if(StringUtils.isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid=?");
			paramList.add(data.getGameid());
		}
		
		if(StringUtils.isNotEmpty(data.getPaybizno())){
			wheresql.append(" And PayBizNo=?");
			paramList.add(data.getPaybizno());
		}
		
		if(StringUtils.isNotEmpty(data.getChargetype())){
			wheresql.append(" And ChargeType=?");
			paramList.add(data.getChargetype());
		}
		
		if(StringUtils.isNotEmpty(data.getBankno())){
			wheresql.append(" And BankNo=?");
			paramList.add(data.getBankno());
		}
		
		if(StringUtils.isNotEmpty(data.getFromusername())){
			wheresql.append(" And FromUserName=?");
			paramList.add(data.getFromusername());
		}
		
		if(StringUtils.isNotEmpty(data.getFrominneruserid())){
			wheresql.append(" And FromInnerUserid=?");
			paramList.add(data.getFrominneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName=?");
			paramList.add(data.getTousername());
		}
		
		if(StringUtils.isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid=?");
			paramList.add(data.getToinneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid=?");
			paramList.add(data.getServerid());
		}
		
		if(StringUtils.isNotEmpty(data.getServername())){
			wheresql.append(" And ServerName=?");
			paramList.add(data.getServername());
		}
		
		if(StringUtils.isNotEmpty(data.getRoleid())){
			wheresql.append(" And RoleId=?");
			paramList.add(data.getRoleid());
		}
		
		if(StringUtils.isNotEmpty(data.getRolename())){
			wheresql.append(" And RoleName=?");
			paramList.add(data.getRolename());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderid())){
			wheresql.append(" And OrderId=?");
			paramList.add(data.getOrderid());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderidstatus())){
			wheresql.append(" And OrderIdStatus=?");
			paramList.add(data.getOrderidstatus());
		}

		if(StringUtils.isNotEmpty(data.getFromOrderTime())){
			String fromOrderTime = data.getFromOrderTime() + " 00:00:00";
			wheresql.append(" And ChargeSuccessTime>=?");
			paramList.add(fromOrderTime);
		}
		
		if(StringUtils.isNotEmpty(data.getToOrderTime())){
			String toOrderTime = data.getToOrderTime() + " 23:59:59";
			wheresql.append(" And ChargeSuccessTime<=?");
			paramList.add(toOrderTime);
		}
		if(StringUtils.isNotEmpty(data.getFromSuccessTme())){
			String fromSuccessTme = data.getFromSuccessTme() + " 00:00:00";
			wheresql.append(" And SuccessTime>=?");
			paramList.add(fromSuccessTme);
		}
		
		if(StringUtils.isNotEmpty(data.getToSuccessTime())){
			String toSuccessTime = data.getToSuccessTime() + " 23:59:59";
			wheresql.append(" And successTime<=?");
			paramList.add(toSuccessTime);
		}
		if(StringUtils.isNotEmpty(data.getReferfrom())){
			wheresql.append(" And Referfrom=?");
			paramList.add(data.getReferfrom());
		}
		if(StringUtils.isNotEmpty(data.getNiuxactno())){
			wheresql.append(" And Niuxactno=?");
			paramList.add(data.getNiuxactno());
		}
		if("1".equals(data.getExcepttest())){
			wheresql.append(" And ToUserName<>'youxiceshi' And ToUserName<> 'fontong'  and  ToUserName<> 'niuxfontong'");
		}else if("2".equals(data.getExcepttest())){
			wheresql.append(" And (ToUserName='youxiceshi' Or ToUserName = 'fontong' or ToUserName='niuxfontong') ");
		}
		if(StringUtils.isNotEmpty(data.getGiftFlag())){
			wheresql.append(" And GiftFlag=?");
			paramList.add(data.getGiftFlag());
		}
		
		sql += wheresql.toString();
		
		sql = sql + " limit 1 ";
		List<PayDetailOK> list = this.executeQuery(PayDetailOK.class, sql, paramList);
		return list.isEmpty() ? null : list.get(0);
	}

	@Override
	public PayDetailOK findMaxPayDetailOK(PayDetailOK data) {
		final PayDetailOK result = new PayDetailOK();
		String sql = "select * from paydetailok ";
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		List<String> params = new ArrayList<String>();
		
		if(StringUtils.isNotEmpty(data.getGameid())){
			wheresql.append(" And gameid=?");
			params.add(data.getGameid());
		}
		if(StringUtils.isNotEmpty(data.getChargetype())){
			wheresql.append(" And ChargeType=?");
			params.add(data.getChargetype());
		}
		
		if(StringUtils.isNotEmpty(data.getBankno())){
			wheresql.append(" And BankNo=?");
			params.add(data.getBankno());
		}
		
		if(StringUtils.isNotEmpty(data.getFromusername())){
			wheresql.append(" And FromUserName=?");
			params.add(data.getFromusername());
		}
		
		if(StringUtils.isNotEmpty(data.getFrominneruserid())){
			wheresql.append(" And FromInnerUserid=?");
			params.add(data.getFrominneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getTousername())){
			wheresql.append(" And ToUserName=?");
			params.add(data.getTousername());
		}
		
		if(StringUtils.isNotEmpty(data.getToinneruserid())){
			wheresql.append(" And ToInnerUserid=?");
			params.add(data.getToinneruserid());
		}
		
		if(StringUtils.isNotEmpty(data.getServerid())){
			wheresql.append(" And Serverid=?");
			params.add(data.getServerid());
		}
		
		if(StringUtils.isNotEmpty(data.getServername())){
			wheresql.append(" And ServerName=?");
			params.add(data.getServername());
		}
		
		if(StringUtils.isNotEmpty(data.getRoleid())){
			wheresql.append(" And RoleId=?");
			params.add(data.getRoleid());
		}
		
		if(StringUtils.isNotEmpty(data.getRolename())){
			wheresql.append(" And RoleName=?");
			params.add(data.getRolename());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderid())){
			wheresql.append(" And OrderId=?");
			params.add(data.getOrderid());
		}
		
		if(StringUtils.isNotEmpty(data.getOrderidstatus())){
			wheresql.append(" And OrderIdStatus=?");
			params.add(data.getOrderidstatus());
		}
		
		if(StringUtils.isNotEmpty(data.getFromOrderTime())){
			wheresql.append(" And ChargeSuccessTime>=?");
			params.add(data.getFromOrderTime()+" 00:00:00");
		}
		
		if(StringUtils.isNotEmpty(data.getToOrderTime())){
			wheresql.append(" And ChargeSuccessTime<=?");
			params.add(data.getToOrderTime()+" 23:59:59");
		}
		if(StringUtils.isNotEmpty(data.getFromSuccessTme())){
			wheresql.append(" And successTime>=?");
			params.add(data.getFromSuccessTme()+" 00:00:00");
		}		
		if(StringUtils.isNotEmpty(data.getToSuccessTime())){
			wheresql.append(" And successTime<=?");
			params.add(data.getToSuccessTime()+" 23:59:59");
		}
		if(StringUtils.isNotEmpty(data.getReferfrom())){
			wheresql.append(" And Referfrom=?");
			params.add(data.getReferfrom());
		}
		if(StringUtils.isNotEmpty(data.getNiuxactno())){
			wheresql.append(" And Niuxactno=?");
			params.add(data.getNiuxactno());
		}
		if("1".equals(data.getExcepttest())){
			wheresql.append(" And ToUserName<>'youxiceshi' And ToUserName<> 'fontong'  and  ToUserName<> 'niuxfontong'");
		}else if("2".equals(data.getExcepttest())){
			wheresql.append(" And (ToUserName='youxiceshi' Or ToUserName = 'fontong'  or ToUserName='niuxfontong') ");
		}
		
		if(StringUtils.isNotEmpty(data.getGiftFlag())){
			wheresql.append(" And GiftFlag=?");
			params.add(data.getGiftFlag());
		}
		

        String theSql = sql + wheresql.toString()+" order by PayMondey desc limit 1 ";
		log.info("sql:"+theSql);
		//double money = this.getSingleDouble(sql + wheresql.toString());
		Map resultMap = this.getJdbcTemplate().queryForMap(theSql, params.toArray());
		if(resultMap != null){
			String price = resultMap.get("price")==null?"0.0":resultMap.get("price").toString();
			String payprice = resultMap.get("payprice")==null?"0.0":resultMap.get("payprice").toString();
			String voucherprice = resultMap.get("voucherprice")==null?"0.0":resultMap.get("voucherprice").toString();
			result.setTotalmoney(price);
			result.setPayMondey(new Double(payprice==null?"0":payprice));
			result.setVouchersMoney(new Double(voucherprice==null?"0":voucherprice));
			//result.setPayMondey(new Double(price)-result.getVouchersMoney());
		}else{
			result.setPayMondey(new Double("0.0"));
			result.setVouchersMoney(new Double("0.0"));
			result.setPayMondey(new Double("0.0"));
		}
		return result;
	}
}
