package com.xunlei.niux.data.bonus.dao;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.bonus.constant.BonusConstant;
import com.xunlei.niux.data.bonus.dto.BonusTransDTO;
import com.xunlei.niux.data.bonus.util.SqlUtil;
import com.xunlei.niux.data.bonus.vo.BonusTrans;

public class BonusTransDaoImpl extends BaseDaoImpl implements BonusTransDao{
	
	private static final Pattern INTERVAL_PATTERN =  Pattern.compile("^(-)?\\d{1,2}\\s[A-Za-z_]+$");

	public void insert(final BonusTrans bonusTrans) {
		StringBuilder sb=new StringBuilder();
		sb.append("insert into ").append(getTableName(bonusTrans.getUserId()))
		  .append("(userId,userName,transDirect,transTime,transNum,transNo,remark,bizNo,transIp,balanceDate,actNo,gameId)")
		  .append(" values(?,?,?,?,?,?,?,?,?,?,?,?)");
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(bonusTrans.getUserId());
		paramList.add(bonusTrans.getUserName());
		paramList.add(bonusTrans.getTransDirect());
		paramList.add(bonusTrans.getTransTime());
		paramList.add(bonusTrans.getTransNum());
		paramList.add(bonusTrans.getTransNo());
		paramList.add(bonusTrans.getRemark());
		paramList.add(bonusTrans.getBizNo());
		paramList.add(bonusTrans.getTransIp());
		paramList.add(bonusTrans.getBalanceDate());
		paramList.add(bonusTrans.getActNo());
		paramList.add(bonusTrans.getGameId());
		this.execute(sb.toString(), paramList);
	}
	public List<BonusTrans> find(final BonusTrans bonusTrans, final Page page) {
		List<Object> paramList=new ArrayList<Object>();
		StringBuilder sb=new StringBuilder();
		sb.append("select * from ").append(getTableName(bonusTrans.getUserId())).append(DaoUtil.createWhere(bonusTrans, paramList))
		  .append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
		return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
	}

	public int count(final String userId, final BonusTrans bonusTrans) {
		List<Object> paramList=new ArrayList<Object>();
		StringBuilder sb=new StringBuilder();
		sb.append("select count(*) from ").append(getTableName(userId)).append(DaoUtil.createWhere(bonusTrans, paramList));
		return this.getJdbcTemplate().queryForInt(sb.toString(), paramList.toArray());
	}
	@Override
	public List<BonusTrans> find(final BonusTrans bonusTrans, final String actNoArr,final Page page) {
		List<Object> paramList=new ArrayList<Object>();
		StringBuilder sb=new StringBuilder();
		sb.append("select * from ").append(getTableName(bonusTrans.getUserId())).append(DaoUtil.createWhere(bonusTrans, paramList))
		.append(" and actno in  ("+actNoArr+")" )
		.append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
		return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
	}
	@Override
	public int count(final String userId, final String actNoArr,final BonusTrans bonusTrans) {
		List<Object> paramList=new ArrayList<Object>();
		StringBuilder sb=new StringBuilder();
		sb.append("select count(*) from ").append(getTableName(userId)).append(DaoUtil.createWhere(bonusTrans, paramList)).append(" and actno in  ("+actNoArr+")" );
		return this.getJdbcTemplate().queryForInt(sb.toString(), paramList.toArray());
	}
	/**
	 * 获取表名，按照hash值分50张分表
	 * @param userId
	 * @return
	 */
	private String getTableName(final String userId){
		if(userId==null||"".equals(userId)){
			throw new RuntimeException("userId为空");
		}
		long xunleiId=Long.valueOf(userId);
		return "bonustrans_"+(xunleiId%50);
	}
	
	@Override
	public List<BonusTrans> findDateSub(final String userId, final String expr,
			final Page page) {
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userId);
		
		//正则表达式验证符合 "9 DAY"等格式
		if(INTERVAL_PATTERN != null){
			Matcher matcher = INTERVAL_PATTERN.matcher(expr);
			if(!matcher.matches()){
				return null;
			}
		}
		
		StringBuilder sb=new StringBuilder();
		sb.append("select * from ")
			.append(getTableName(userId))
			.append(" where userid = ? ")
			.append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') >= DATE_SUB(CURRENT_DATE(),INTERVAL  "+expr+" ) ")
			.append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
		return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
	}
	@Override
	public List<BonusTrans> findPeriod(final String userId, final String startTime,
			final String endTime, final Page page) {
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userId);
		paramList.add(startTime);
		paramList.add(endTime);
		StringBuilder sb=new StringBuilder();
		sb.append("select * from ")
			.append(getTableName(userId))
			.append(" where userid = ? ")
			.append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') >= DATE_FORMAT(?,'%Y-%m-%d') ")
			.append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') <= DATE_FORMAT(?,'%Y-%m-%d') ")
			.append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
		return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
	}
	
	@Override
	public Integer getTodayBonus(String userId){
		StringBuilder sb =new StringBuilder();
		sb.append("select sum(transNum) from " + getTableName(userId));
		sb.append(" where transDirect=? and balanceDate=? and userId=?");
		
		SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd");
		String dateStr = simpleDateFormat.format(new Date());
		
		Object[] args = new Object[3];
		args[0] = BonusConstant.BONUS_TRANSDIRECT_RECHARGE;
		args[1] = dateStr;
		args[2] = userId;
		        
		Integer todayBonus = this.getJdbcTemplate().queryForInt(sb.toString(), args);
		
		return todayBonus;
		
	}
	@Override
	public List<BonusTransDTO> getBonusRecords(String userId, Page page) {
		return getBonusRecords(userId, null, page);
	}
	
	@Override
	public List<BonusTransDTO> getBonusRecords(String userId, String expr, Page page) {
		if(expr != null && INTERVAL_PATTERN != null) {
			Matcher matcher = INTERVAL_PATTERN.matcher(expr);
			if(!matcher.matches()){
				return null;
			}
		}
		
		StringBuilder sb = new StringBuilder();
		sb.append("SELECT b.*, a.title FROM niux_jifen.")
		.append(getTableName(userId))
		.append(" b JOIN vip_game_info.activity a ON a.actNo = b.actNo WHERE b.userId = ? ");
		
		if(expr != null) {
			sb.append("AND DATE_FORMAT(b.transTime,'%Y-%m-%d') >= DATE_SUB(CURRENT_DATE(),INTERVAL ")
			.append(expr)
			.append(" ) ");
		}
		
		sb.append("ORDER BY b.transTime DESC ");
		sb.append(SqlUtil.createLimit(page));
		
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userId);
		
		return this.executeQuery(BonusTransDTO.class, sb.toString(), paramList);
	}
	
	@Override
	public int countBonusRecords(String userId, String expr) {
		if(expr != null && INTERVAL_PATTERN != null) {
			Matcher matcher = INTERVAL_PATTERN.matcher(expr);
			if(!matcher.matches()){
				return 0;
			}
		}
		
		StringBuilder sb = new StringBuilder()
			.append("SELECT COUNT(b.seqId) FROM niux_jifen.")
			.append(getTableName(userId))
			.append(" b JOIN vip_game_info.activity a ON a.actNo = b.actNo WHERE b.userId = ? ");
		
		if(expr != null) {
			sb.append("AND DATE_FORMAT(b.transTime,'%Y-%m-%d') >= DATE_SUB(CURRENT_DATE(),INTERVAL ")
			.append(expr)
			.append(" ) ");
		}
		
		return getJdbcTemplate().queryForInt(sb.toString(), new Object[] { userId });
	}
}
