package com.xunlei.niux.data.bonus.bo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.bonus.vo.UserBonusSort;
@Service
public class UserBonusSortBoImpl implements UserBonusSortBo{
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	@Override
	public void execSql(String sql) {
		baseDao.execute(sql, new ArrayList<Object>());
	}
	public UserBonusSort findByUserId(String userId){
		if(userId==null||"".equals(userId)){
			throw new RuntimeException("userId为空");
		}
		UserBonusSort ubs=new UserBonusSort();
		ubs.setUserId(userId);
		List<UserBonusSort> list=baseDao.findByObject(UserBonusSort.class, ubs, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public UserBonusSort findByUserId(int sortNum){
		if(sortNum<=0){
			return null;
		}
		UserBonusSort ubs=new UserBonusSort();
		ubs.setSortNum(sortNum);
		List<UserBonusSort> list=baseDao.findByObject(UserBonusSort.class, ubs, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<UserBonusSort> finds(UserBonusSort ubs,Page page){
		return baseDao.findByObject(UserBonusSort.class, ubs, page);
	}
	public int count(UserBonusSort ubs){
		return baseDao.count(ubs);
	}
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

}
