package com.xunlei.niux.data.bonus.bo;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.bonus.constant.BonusConstant;
import com.xunlei.niux.data.bonus.constant.SqlLock;
import com.xunlei.niux.data.bonus.dao.BonusTransDao;
import com.xunlei.niux.data.bonus.dao.UserBonusDao;
import com.xunlei.niux.data.bonus.dto.BonusTransDTO;
import com.xunlei.niux.data.bonus.exception.BonusErrorCode;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.vo.BonusTrans;
import com.xunlei.niux.data.bonus.vo.UserBonus;
@Service
public class BonusTransBoImpl implements BonusTransBo {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Autowired
	private BonusTransDao bonusTransDao;
	@Autowired
	private UserBonusDao userBonusDao;
	
	public BonusTrans find(final String userId, final long seqId) {
		BonusTrans bonusTrans=new BonusTrans();
		bonusTrans.setUserId(userId);
		bonusTrans.setSeqId(seqId);
		List<BonusTrans> list=find(bonusTrans,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<BonusTrans> find(final BonusTrans bonusTrans,final Page page){
		return bonusTransDao.find(bonusTrans, page);
	}
	public int count(final BonusTrans pTrans){
		if(pTrans.getUserId()==null||"".equals(pTrans.getUserId())){
			throw new RuntimeException("userid为空");
		}
		return bonusTransDao.count(pTrans.getUserId(), pTrans);
	}
	public List<BonusTrans> find(final BonusTrans bonusTrans, final String actNoArr, final Page page){
		return bonusTransDao.find(bonusTrans, actNoArr, page);
	}
	public int count(final BonusTrans pTrans, final String actNoArr){
		if(pTrans.getUserId()==null||"".equals(pTrans.getUserId())){
			throw new RuntimeException("userid为空");
		}
		return bonusTransDao.count(pTrans.getUserId(), actNoArr, pTrans);
	}
	public BonusTrans find(final String userId,final String bizNo,final String transNo,final String transDirect){
		BonusTrans bonusTrans=new BonusTrans();
		bonusTrans.setUserId(userId);
		bonusTrans.setBizNo(bizNo);
		bonusTrans.setTransNo(transNo);
		bonusTrans.setTransDirect(transDirect);
		List<BonusTrans> list=find(bonusTrans,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	/**
	 * 插入积分交易
	 */
	public void insert(final BonusTrans bonusTrans) {
		if(bonusTrans==null){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009,"积分交易为空");
		}
		//检查参数是否合法
		checkBonusTransParam(bonusTrans);
		//判断业务编号和申请未编号是否已经插入
		if(find(bonusTrans.getUserId(),bonusTrans.getBizNo(),bonusTrans.getTransNo(),bonusTrans.getTransDirect())!=null){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1001,"业务号["+bonusTrans.getBizNo()
					+"]的交易编号["+bonusTrans.getTransNo()+"]交易方向["+bonusTrans.getTransDirect()+"]已处理");
		}
		//查询用户积分信息，并且锁定
		UserBonus userBonus=userBonusDao.find(bonusTrans.getUserId(), SqlLock.UPDATE);
		//计算积分
		userBonus=calUserBonus(userBonus, bonusTrans);
		if(userBonus.getSeqId()==null||userBonus.getSeqId()<=0){
			//插入数据
			userBonusDao.insert(userBonus);
		}else{
			//更新数据
			userBonusDao.update(userBonus);
		}
		//插入积分交易记录
		bonusTrans.setTransTime(sdf.format(new Date()));
		bonusTransDao.insert(bonusTrans);
	}
	/**
	 * 计算用户积分transdirect=1:消费积分；transdirect=2:充值积分；
	 */
	private UserBonus calUserBonus(final UserBonus userBonus,final BonusTrans bonusTrans){
		if(BonusConstant.BONUS_TRANSDIRECT_CONSUME.equals(bonusTrans.getTransDirect())){
			//消费积分
			return calUserBonusConsume(userBonus, bonusTrans);
		}else if(BonusConstant.BONUS_TRANSDIRECT_RECHARGE.equals(bonusTrans.getTransDirect())){
			//充值积分
			return calUserBonusRecharge(userBonus, bonusTrans);
		}else if(BonusConstant.BONUS_TRANSDIRECT_CONSUMERETURN.equals(bonusTrans.getTransDirect())){
			//消费积分返还
			return calUserBonusConsumeReturn(userBonus, bonusTrans);
		}
		else{
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009,"积分交易类型["+bonusTrans.getTransDirect()+"]未知");
		}
	}
	/**
	 * 计算充值积分
	 * @param userBonus
	 * @param bonusTrans
	 * @return
	 */
	private UserBonus calUserBonusRecharge(UserBonus userBonus,final BonusTrans bonusTrans){
		if(userBonus==null){
			//第一次记录
			userBonus=new UserBonus();
			userBonus.setUserId(bonusTrans.getUserId());
			userBonus.setUserName(bonusTrans.getUserName());
			userBonus.setBonusLevel(0);
			userBonus.setBonusNum(0);
			userBonus.setConsumeSum(0L);
			userBonus.setRechargeSum(0L);
			userBonus.setBonusStatus(0);
		}
		userBonus.setBonusNum(userBonus.getBonusNum()+bonusTrans.getTransNum());
		userBonus.setRechargeSum(userBonus.getRechargeSum()+bonusTrans.getTransNum());
		userBonus.setLastRechargeTime(sdf.format(new Date()));
		userBonus.setBonusLevel(calUserBonusLevel(userBonus));
		if(userBonus.getBonusNum()<0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1002,"用户["+userBonus.getUserId()+"]积分溢出");
		}
		return userBonus;
	}
	/**
	 * 用户消费积分返还（退单）
	 * @param userBonus
	 * @param bonusTrans
	 * @return
	 */
	private UserBonus calUserBonusConsumeReturn(final UserBonus userBonus,final BonusTrans bonusTrans){
		if(userBonus==null){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1020,"积分不存在");
		}
		if(userBonus.getConsumeSum()-bonusTrans.getTransNum()<0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1021,"用户["+userBonus.getUserId()+"]返还积分不够");
		}
		userBonus.setBonusNum(userBonus.getBonusNum()+bonusTrans.getTransNum());
		userBonus.setConsumeSum(userBonus.getConsumeSum()-bonusTrans.getTransNum());
		if(userBonus.getBonusNum()<0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1002,"用户["+userBonus.getUserId()+"]积分溢出");
		}
		return userBonus;
	}
	/**
	 * 计算消费积分
	 * @param userBonus
	 * @param bonusTrans
	 * @return
	 */
	private UserBonus calUserBonusConsume(final UserBonus userBonus,final BonusTrans bonusTrans){
		if(userBonus==null){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1020,"积分不存在");
		}
		if(userBonus.getBonusStatus()>0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1022,"用户["+userBonus.getUserId()+"]积分被冻结");
		}
		if(userBonus.getBonusNum()-bonusTrans.getTransNum()<0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1021,"用户["+userBonus.getUserId()+"]积分不够");
		}
		userBonus.setBonusNum(userBonus.getBonusNum()-bonusTrans.getTransNum());
		userBonus.setConsumeSum(userBonus.getConsumeSum()+bonusTrans.getTransNum());
		if(userBonus.getConsumeSum()<0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1002,"用户["+userBonus.getUserId()+"]消费积分溢出");
		}
		userBonus.setLastConsumeTime(sdf.format(new Date()));
		return userBonus;
	}
	public void checkBonusTransParam(final BonusTrans bonusTrans){
		if(bonusTrans.getTransNo()==null||"".equals(bonusTrans.getTransNo())){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009,"交易编号为空");
		}
		if(bonusTrans.getTransDirect()==null||"".equals(bonusTrans.getTransDirect())){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009,"积分交易方向为空");
		}
		if(bonusTrans.getTransNum()<=0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009,"交易积分小于或等于0");
		}
	}
	/**
	 * 计算积分等级
	 * @param userBonus
	 * @return
	 */
	private int calUserBonusLevel(final UserBonus userBonus){
		Long sumbonus=userBonus.getRechargeSum();
		if(sumbonus<5){
			return 0;
		}
		if(sumbonus<10){
			return 1;
		}
		if(sumbonus<15){
			return 2;
		}
		if(sumbonus<20){
			return 3;
		}
		if(sumbonus<30){
			return 4;
		}
		if(sumbonus<40){
			return 5;
		}
		if(sumbonus<50){
			return 6;
		}
		if(sumbonus<60){
			return 7;
		}
		if(sumbonus<75){
			return 8;
		}
		if(sumbonus<90){
			return 9;
		}
		for(int i=10;i<99;i++){
			if((i-4)*(i-4)*3>sumbonus){
				return i;
			}
		}
		return 99;
	}
	public BonusTransDao getBonusTransDao() {
		return bonusTransDao;
	}
	public void setBonusTransDao(final BonusTransDao bonusTransDao) {
		this.bonusTransDao = bonusTransDao;
	}
	public UserBonusDao getUserBonusDao() {
		return userBonusDao;
	}
	public void setUserBonusDao(final UserBonusDao userBonusDao) {
		this.userBonusDao = userBonusDao;
	}
	
	
	@Override
	public List<BonusTrans> findDateSub(final String userId, final String expr,
			final Page page) {
		return bonusTransDao.findDateSub(userId, expr, page);
	}
	@Override
	public List<BonusTrans> findPeriod(final String userId, final String startTime,
			final String endTime, final Page page) {
		return bonusTransDao.findPeriod(userId, startTime, endTime, page);
	}
	
	public Integer getTodayBonus(String userId){
		return bonusTransDao.getTodayBonus(userId);
	}
	
	@Override
	public List<BonusTransDTO> getBonusRecords(String userId, Page page) {
		return getBonusRecords(userId, null, page);
	}
	@Override
	public List<BonusTransDTO> getBonusRecords(String userId, String expr,
			Page page) {
		return bonusTransDao.getBonusRecords(userId, expr, page);
	}
	@Override
	public int countBonusRecords(String userId, String expr) {
		return bonusTransDao.countBonusRecords(userId, expr);
	}
	@Override
	public int countBonusRecords(String userId) {
		return countBonusRecords(userId, null);
	}
}
