package com.xunlei.niux.data.bonus.bo;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.bonus.vo.BonusLevel;
@Service
public class BonusLevelBoImpl implements BonusLevelBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;

	public List<BonusLevel> find(BonusLevel bonusLevel, Page page) {
		return baseDao.findByObject(BonusLevel.class, bonusLevel, page);
	}
	public void update(Map<Integer,BonusLevel> bonusLevelMap){
		if(bonusLevelMap==null){
			return;
		}
		Set<Integer> keySet=bonusLevelMap.keySet();
		Iterator<Integer> it=keySet.iterator();
		while(it.hasNext()){
			int levelNum=it.next();
			BonusLevel bonusLevel=bonusLevelMap.get(levelNum);
			BonusLevel curLevel=find(levelNum);
			if(curLevel==null){
				continue;
			}
			curLevel.setSumUserNum(bonusLevel.getSumUserNum());
			update(curLevel);
		}
	}
	
	public BonusLevel find(Integer levelNum){
		BonusLevel bonusLevel=new BonusLevel();
		bonusLevel.setLevelNum(levelNum);
		List<BonusLevel> list=find(bonusLevel,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public void insert(BonusLevel bonusLevel) {
		 baseDao.insert(bonusLevel);
	}

	public void update(BonusLevel bonusLevel) {
		baseDao.updateById(bonusLevel);
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

}
