/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.bonus.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.bonus.constant.SqlLock;
import com.xunlei.niux.data.bonus.dao.UserBonusDao;
import com.xunlei.niux.data.bonus.util.SqlUtil;
import com.xunlei.niux.data.bonus.vo.BonusLevel;
import com.xunlei.niux.data.bonus.vo.UserBonus;
import java.util.ArrayList;
import java.util.List;

public class UserBonusDaoImpl
extends BaseDaoImpl
implements UserBonusDao {
    @Override
    public void update(UserBonus userBonus) {
        if (userBonus == null) {
            throw new RuntimeException("\u7528\u6237\u79ef\u5206\u4e3a\u7a7a");
        }
        if (userBonus.getUserId() == null || "".equals(userBonus.getUserId())) {
            throw new RuntimeException("\u7528\u6237\u79ef\u5206\u7684userId\u4e3a\u7a7a");
        }
        if (userBonus.getSeqId() == null || 0L >= userBonus.getSeqId()) {
            throw new RuntimeException("\u7528\u6237[" + userBonus.getUserId() + "]\u79ef\u5206\u7684seqId\u4e3a\u7a7a");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(this.getTableName(userBonus.getUserId())).append(" set userName=?,rechargeSum=?,consumeSum=?,bonusNum=?").append(",bonusLevel=?,bonusStatus=?,lastRechargeTime=?,lastConsumeTime=?,remark=?").append(" where seqId=? and userId=?");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(userBonus.getUserName());
        paramList.add(userBonus.getRechargeSum());
        paramList.add(userBonus.getConsumeSum());
        paramList.add(userBonus.getBonusNum());
        paramList.add(userBonus.getBonusLevel());
        paramList.add(userBonus.getBonusStatus());
        paramList.add(userBonus.getLastRechargeTime());
        paramList.add(userBonus.getLastConsumeTime());
        paramList.add(userBonus.getRemark());
        paramList.add(userBonus.getSeqId());
        paramList.add(userBonus.getUserId());
        this.execute(sb.toString(), paramList);
    }

    @Override
    public void insert(UserBonus userBonus) {
        if (userBonus == null) {
            throw new RuntimeException("\u7528\u6237\u79ef\u5206\u4e3a\u7a7a");
        }
        if (userBonus == null || "".equals(userBonus)) {
            throw new RuntimeException("\u7528\u6237\u79ef\u5206\u7684userId\u4e3a\u7a7a");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(this.getTableName(userBonus.getUserId())).append(" (userId,userName,rechargeSum,consumeSum,bonusNum,bonusLevel,bonusStatus,lastRechargeTime,lastConsumeTime,remark)").append(" values(?,?,?,?,?,?,?,?,?,?)");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(userBonus.getUserId());
        paramList.add(userBonus.getUserName());
        paramList.add(userBonus.getRechargeSum());
        paramList.add(userBonus.getConsumeSum());
        paramList.add(userBonus.getBonusNum());
        paramList.add(userBonus.getBonusLevel());
        paramList.add(userBonus.getBonusStatus());
        paramList.add(userBonus.getLastRechargeTime());
        paramList.add(userBonus.getLastConsumeTime());
        paramList.add(userBonus.getRemark());
        this.execute(sb.toString(), paramList);
    }

    @Override
    public UserBonus find(String userId) {
        return this.find(userId, null);
    }

    @Override
    public UserBonus find(String userId, SqlLock lock) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(userId)).append(" where userId=?").append(SqlUtil.getLockStr(lock));
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        List list = this.executeQuery(UserBonus.class, sb.toString(), paramList);
        return list == null || list.size() == 0 ? null : (UserBonus)list.get(0);
    }

    private String getTableName(String userId) {
        if (userId == null || "".equals(userId)) {
            throw new RuntimeException("userId\u4e3a\u7a7a");
        }
        long xunleiId = Long.valueOf(userId);
        return "userbonus_" + xunleiId % 50L;
    }

    @Override
    public List<BonusLevel> getBonusLevelUserNum(int userTableIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append("select bonusLevel seqId,bonusLevel levelNum, bonusLevel levelName,bonusLevel levelIconUrl,bonusLevel minBonusNum,count(*) sumUserNum from userbonus_").append(userTableIndex).append(" group by bonusLevel");
        ArrayList paramList = new ArrayList();
        return this.executeQuery(BonusLevel.class, sb.toString(), paramList);
    }

    @Override
    public List<UserBonus> getTopBonusUser(int userTableIndex, int topNum) {
        StringBuilder sb = new StringBuilder();
        sb.append("select *  from userbonus_").append(userTableIndex).append(" order by rechargeSum desc,lastRechargeTime asc");
        if (topNum > 0) {
            sb.append(" limit 0,").append(topNum);
        }
        ArrayList paramList = new ArrayList();
        return this.executeQuery(UserBonus.class, sb.toString(), paramList);
    }
}

