/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.bonus.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.bonus.dao.BonusTransDao;
import com.xunlei.niux.data.bonus.dto.BonusTransDTO;
import com.xunlei.niux.data.bonus.util.SqlUtil;
import com.xunlei.niux.data.bonus.vo.BonusTrans;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BonusTransDaoImpl
extends BaseDaoImpl
implements BonusTransDao {
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("^(-)?\\d{1,2}\\s[A-Za-z_]+$");

    @Override
    public void insert(BonusTrans bonusTrans) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(this.getTableName(bonusTrans.getUserId())).append("(userId,userName,transDirect,transTime,transNum,transNo,remark,bizNo,transIp,balanceDate,actNo,gameId)").append(" values(?,?,?,?,?,?,?,?,?,?,?,?)");
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(bonusTrans.getUserId());
        paramList.add(bonusTrans.getUserName());
        paramList.add(bonusTrans.getTransDirect());
        paramList.add(bonusTrans.getTransTime());
        paramList.add(bonusTrans.getTransNum());
        paramList.add(bonusTrans.getTransNo());
        paramList.add(bonusTrans.getRemark());
        paramList.add(bonusTrans.getBizNo());
        paramList.add(bonusTrans.getTransIp());
        paramList.add(bonusTrans.getBalanceDate());
        paramList.add(bonusTrans.getActNo());
        paramList.add(bonusTrans.getGameId());
        this.execute(sb.toString(), paramList);
    }

    @Override
    public List<BonusTrans> find(BonusTrans bonusTrans, Page page) {
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(bonusTrans.getUserId())).append(DaoUtil.createWhere((Object)bonusTrans, paramList)).append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
        return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
    }

    @Override
    public int count(String userId, BonusTrans bonusTrans) {
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from ").append(this.getTableName(userId)).append(DaoUtil.createWhere((Object)bonusTrans, paramList));
        return this.getJdbcTemplate().queryForInt(sb.toString(), paramList.toArray());
    }

    @Override
    public List<BonusTrans> find(BonusTrans bonusTrans, String actNoArr, Page page) {
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(bonusTrans.getUserId())).append(DaoUtil.createWhere((Object)bonusTrans, paramList)).append(" and actno in  (" + actNoArr + ")").append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
        return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
    }

    @Override
    public int count(String userId, String actNoArr, BonusTrans bonusTrans) {
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from ").append(this.getTableName(userId)).append(DaoUtil.createWhere((Object)bonusTrans, paramList)).append(" and actno in  (" + actNoArr + ")");
        return this.getJdbcTemplate().queryForInt(sb.toString(), paramList.toArray());
    }

    private String getTableName(String userId) {
        if (userId == null || "".equals(userId)) {
            throw new RuntimeException("userId\u4e3a\u7a7a");
        }
        long xunleiId = Long.valueOf(userId);
        return "bonustrans_" + xunleiId % 50L;
    }

    @Override
    public List<BonusTrans> findDateSub(String userId, String expr, Page page) {
        Matcher matcher;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        if (INTERVAL_PATTERN != null && !(matcher = INTERVAL_PATTERN.matcher(expr)).matches()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(userId)).append(" where userid = ? ").append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') >= DATE_SUB(CURRENT_DATE(),INTERVAL  " + expr + " ) ").append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
        return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
    }

    @Override
    public List<BonusTrans> findPeriod(String userId, String startTime, String endTime, Page page) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        paramList.add(startTime);
        paramList.add(endTime);
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(this.getTableName(userId)).append(" where userid = ? ").append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') >= DATE_FORMAT(?,'%Y-%m-%d') ").append(" AND DATE_FORMAT(transTime,'%Y-%m-%d') <= DATE_FORMAT(?,'%Y-%m-%d') ").append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
        return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
    }

    @Override
    public Integer getTodayBonus(String userId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select sum(transNum) from " + this.getTableName(userId));
        sb.append(" where transDirect=? and balanceDate=? and userId=?");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = simpleDateFormat.format(new Date());
        Object[] args = new Object[]{"2", dateStr, userId};
        Integer todayBonus = this.getJdbcTemplate().queryForInt(sb.toString(), args);
        return todayBonus;
    }

    @Override
    public List<BonusTransDTO> getBonusRecords(String userId, Page page) {
        return this.getBonusRecords(userId, null, page);
    }

    @Override
    public List<BonusTransDTO> getBonusRecords(String userId, String expr, Page page) {
        Matcher matcher;
        if (expr != null && INTERVAL_PATTERN != null && !(matcher = INTERVAL_PATTERN.matcher(expr)).matches()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT b.*, a.title FROM niux_jifen.").append(this.getTableName(userId)).append(" b JOIN vip_game_info.activity a ON a.actNo = b.actNo WHERE b.userId = ? AND a.actstatus = '1' ");
        if (expr != null) {
            sb.append("AND DATE_FORMAT(b.transTime,'%Y-%m-%d') >= DATE_SUB(CURRENT_DATE(),INTERVAL ").append(expr).append(" ) ");
        }
        sb.append("ORDER BY b.transTime DESC ");
        sb.append(SqlUtil.createLimit(page));
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(userId);
        return this.executeQuery(BonusTransDTO.class, sb.toString(), paramList);
    }
}

