/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.bonus.bo;

import com.xunlei.niux.data.bonus.bo.UserBonusBo;
import com.xunlei.niux.data.bonus.constant.SqlLock;
import com.xunlei.niux.data.bonus.dao.UserBonusDao;
import com.xunlei.niux.data.bonus.vo.BonusLevel;
import com.xunlei.niux.data.bonus.vo.UserBonus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBonusBoImpl
implements UserBonusBo {
    @Autowired
    private UserBonusDao userBonusDao;

    @Override
    public UserBonus find(String userId) {
        return this.userBonusDao.find(userId);
    }

    @Override
    public void update(UserBonus userBonus) {
        this.userBonusDao.update(userBonus);
    }

    @Override
    public void insert(UserBonus userBonus) {
        this.userBonusDao.insert(userBonus);
    }

    @Override
    public List<UserBonus> getTopBonusUser(int topNum) {
        ArrayList<UserBonus> list = new ArrayList<UserBonus>();
        for (int i = 0; i < 50; ++i) {
            list.addAll(this.userBonusDao.getTopBonusUser(i, topNum));
        }
        return list;
    }

    @Override
    public List<UserBonus> getTableTopBonusUser(int tableindex, int topNum) {
        return this.userBonusDao.getTopBonusUser(tableindex, topNum);
    }

    @Override
    public Map<Integer, BonusLevel> getBonusLevelUserNum() {
        HashMap<Integer, BonusLevel> resultMap = new HashMap<Integer, BonusLevel>();
        for (int i = 0; i < 50; ++i) {
            List<BonusLevel> list = this.userBonusDao.getBonusLevelUserNum(i);
            if (list == null) continue;
            for (BonusLevel bonusLevel : list) {
                BonusLevel rLevel = (BonusLevel)resultMap.get(bonusLevel.getLevelNum());
                if (rLevel == null) {
                    rLevel = bonusLevel;
                    resultMap.put(bonusLevel.getLevelNum(), rLevel);
                    continue;
                }
                rLevel.setSumUserNum(rLevel.getSumUserNum() + bonusLevel.getSumUserNum());
            }
        }
        return resultMap;
    }

    @Override
    public void update_freeze(String userId) {
        UserBonus userBonus = this.userBonusDao.find(userId, SqlLock.UPDATE);
        if (userBonus == null) {
            throw new RuntimeException("userID[" + userId + "]\u4e0d\u5b58\u5728");
        }
        if (userBonus.getBonusStatus() == 1) {
            return;
        }
        userBonus.setBonusStatus(1);
        this.userBonusDao.update(userBonus);
    }

    @Override
    public void update_unfreeze(String userId) {
        UserBonus userBonus = this.userBonusDao.find(userId, SqlLock.UPDATE);
        if (userBonus == null) {
            throw new RuntimeException("userID[" + userId + "]\u4e0d\u5b58\u5728");
        }
        if (userBonus.getBonusStatus() == 0) {
            return;
        }
        userBonus.setBonusStatus(0);
        this.userBonusDao.update(userBonus);
    }
}

