package com.xunlei.niux.data.bonus.dao;


import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.bonus.constant.SqlLock;
import com.xunlei.niux.data.bonus.util.SqlUtil;
import com.xunlei.niux.data.bonus.vo.BonusLevel;
import com.xunlei.niux.data.bonus.vo.UserBonus;
public class UserBonusDaoImpl extends BaseDaoImpl implements UserBonusDao {
	public void update(UserBonus userBonus) {
		if(userBonus==null){
			throw new RuntimeException("用户积分为空");
		}
		if(userBonus.getUserId()==null||"".equals(userBonus.getUserId())){
			throw new RuntimeException("用户积分的userId为空");
		}
		if(userBonus.getSeqId()==null||0>=userBonus.getSeqId()){
			throw new RuntimeException("用户["+userBonus.getUserId()+"]积分的seqId为空");
		}
		StringBuilder sb=new StringBuilder();
		sb.append("update ").append(getTableName(userBonus.getUserId()))
		  .append(" set userName=?,rechargeSum=?,consumeSum=?,bonusNum=?")
		  .append(",bonusLevel=?,bonusStatus=?,lastRechargeTime=?,lastConsumeTime=?,remark=?")
		  .append(" where seqId=? and userId=?");
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userBonus.getUserName());
		paramList.add(userBonus.getRechargeSum());
		paramList.add(userBonus.getConsumeSum());
		paramList.add(userBonus.getBonusNum());
		paramList.add(userBonus.getBonusLevel());
		paramList.add(userBonus.getBonusStatus());
		paramList.add(userBonus.getLastRechargeTime());
		paramList.add(userBonus.getLastConsumeTime());
		paramList.add(userBonus.getRemark());
		paramList.add(userBonus.getSeqId());
		paramList.add(userBonus.getUserId());
		this.execute(sb.toString(), paramList);
	}
	public void insert(UserBonus userBonus) {
		if(userBonus==null){
			throw new RuntimeException("用户积分为空");
		}
		if(userBonus==null||"".equals(userBonus)){
			throw new RuntimeException("用户积分的userId为空");
		}
		StringBuilder sb=new StringBuilder();
		sb.append("insert into ").append(getTableName(userBonus.getUserId()))
		  .append(" (userId,userName,rechargeSum,consumeSum,bonusNum,bonusLevel,bonusStatus,lastRechargeTime,lastConsumeTime,remark)")
		  .append(" values(?,?,?,?,?,?,?,?,?,?)");
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userBonus.getUserId());
		paramList.add(userBonus.getUserName());
		paramList.add(userBonus.getRechargeSum());
		paramList.add(userBonus.getConsumeSum());
		paramList.add(userBonus.getBonusNum());
		paramList.add(userBonus.getBonusLevel());
		paramList.add(userBonus.getBonusStatus());
		paramList.add(userBonus.getLastRechargeTime());
		paramList.add(userBonus.getLastConsumeTime());
		paramList.add(userBonus.getRemark());
		this.execute(sb.toString(), paramList);
	}
	public UserBonus find(String userId) {
		return find(userId,null);
	}

	public UserBonus find(String userId, SqlLock lock) {
		StringBuilder sb=new StringBuilder();
		sb.append("select * from ").append(getTableName(userId))
		  .append(" where userId=?").append(SqlUtil.getLockStr(lock));
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userId);
		List<UserBonus> list=this.executeQuery(UserBonus.class, sb.toString(), paramList);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	/**
	 * 获取表名，按照hash值分50张分表
	 * @param userId
	 * @return
	 */
	private String getTableName(String userId){
		if(userId==null||"".equals(userId)){
			throw new RuntimeException("userId为空");
		}
		long xunleiId=Long.valueOf(userId);
		return "userbonus_"+(xunleiId%50);
	}
	public List<BonusLevel> getBonusLevelUserNum(int userTableIndex){
		StringBuilder sb=new StringBuilder();
		sb.append("select bonusLevel seqId,bonusLevel levelNum, bonusLevel levelName,bonusLevel levelIconUrl,bonusLevel minBonusNum,count(*) sumUserNum from userbonus_").append(userTableIndex)
		  .append(" group by bonusLevel");
		List<Object> paramList=new ArrayList<Object>();
		return this.executeQuery(BonusLevel.class, sb.toString(), paramList);
	}
	public List<UserBonus> getTopBonusUser(int userTableIndex,int topNum){
		StringBuilder sb =new StringBuilder();
		sb.append("select *  from userbonus_").append(userTableIndex)
		  .append(" order by rechargeSum desc,lastRechargeTime asc");
		if(topNum>0){
			sb.append(" limit 0,").append(topNum);
		}
		List<Object> paramList=new ArrayList<Object>();
		return this.executeQuery(UserBonus.class, sb.toString(), paramList);
	}
}
