package com.xunlei.niux.data.bonus.dao;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.bonus.util.SqlUtil;
import com.xunlei.niux.data.bonus.vo.BonusTrans;

public class BonusTransDaoImpl extends BaseDaoImpl implements BonusTransDao{

	public void insert(BonusTrans bonusTrans) {
		StringBuilder sb=new StringBuilder();
		sb.append("insert into ").append(getTableName(bonusTrans.getUserId()))
		  .append("(userId,userName,transDirect,transTime,transNum,transNo,remark,bizNo,transIp,balanceDate,actNo,gameId)")
		  .append(" values(?,?,?,?,?,?,?,?,?,?,?,?)");
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(bonusTrans.getUserId());
		paramList.add(bonusTrans.getUserName());
		paramList.add(bonusTrans.getTransDirect());
		paramList.add(bonusTrans.getTransTime());
		paramList.add(bonusTrans.getTransNum());
		paramList.add(bonusTrans.getTransNo());
		paramList.add(bonusTrans.getRemark());
		paramList.add(bonusTrans.getBizNo());
		paramList.add(bonusTrans.getTransIp());
		paramList.add(bonusTrans.getBalanceDate());
		paramList.add(bonusTrans.getActNo());
		paramList.add(bonusTrans.getGameId());
		this.execute(sb.toString(), paramList);
	}
	public List<BonusTrans> find(BonusTrans bonusTrans, Page page) {
		List<Object> paramList=new ArrayList<Object>();
		StringBuilder sb=new StringBuilder();
		sb.append("select * from ").append(getTableName(bonusTrans.getUserId())).append(DaoUtil.createWhere(bonusTrans, paramList))
		  .append(SqlUtil.createOrder(BonusTrans.class, page)).append(SqlUtil.createLimit(page));
		return this.executeQuery(BonusTrans.class, sb.toString(), paramList);
	}

	public int count(String userId, BonusTrans bonusTrans) {
		List<Object> paramList=new ArrayList<Object>();
		StringBuilder sb=new StringBuilder();
		sb.append("select count(*) from ").append(getTableName(userId)).append(DaoUtil.createWhere(bonusTrans, paramList));
		return this.getJdbcTemplate().queryForInt(sb.toString(), paramList.toArray());
	}
	/**
	 * 获取表名，按照hash值分50张分表
	 * @param userId
	 * @return
	 */
	private String getTableName(String userId){
		if(userId==null||"".equals(userId)){
			throw new RuntimeException("userId为空");
		}
		long xunleiId=Long.valueOf(userId);
		return "bonustrans_"+(xunleiId%50);
	}
}
