package com.xunlei.niux.data.bonus.bo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xunlei.niux.data.bonus.constant.SqlLock;
import com.xunlei.niux.data.bonus.dao.UserBonusDao;
import com.xunlei.niux.data.bonus.vo.BonusLevel;
import com.xunlei.niux.data.bonus.vo.UserBonus;
@Service
public class UserBonusBoImpl implements UserBonusBo {
	@Autowired
	private UserBonusDao userBonusDao;
	
	public UserBonus find(String userId) {
		return userBonusDao.find(userId);
	}
	public void update(UserBonus userBonus){
		userBonusDao.update(userBonus);
	}
	public void insert(UserBonus userBonus){
		userBonusDao.insert(userBonus);
	} 
	public List<UserBonus> getTopBonusUser(int topNum){
		List<UserBonus> list=new ArrayList<UserBonus>();
		for(int i=0;i<50;i++){
			list.addAll(userBonusDao.getTopBonusUser(i, topNum));
		}
		return list;
	}
	public List<UserBonus> getTableTopBonusUser(int tableindex,int topNum){
		return userBonusDao.getTopBonusUser(tableindex, topNum);
	}
	/**
	 * 
	 * @return
	 */
	public Map<Integer,BonusLevel> getBonusLevelUserNum(){
		Map<Integer,BonusLevel> resultMap=new HashMap<Integer,BonusLevel>();
		for(int i=0;i<50;i++){
			List<BonusLevel> list=userBonusDao.getBonusLevelUserNum(i);
			if(list==null){
				continue;
			}
			for(BonusLevel bonusLevel:list){
				BonusLevel rLevel=resultMap.get(bonusLevel.getLevelNum());
				if(rLevel==null){
					rLevel=bonusLevel;
					resultMap.put(bonusLevel.getLevelNum(), rLevel);
				}else{
					rLevel.setSumUserNum(rLevel.getSumUserNum()+bonusLevel.getSumUserNum());
				}
			}
		}
		return resultMap;
	}
	/**
	 * 冻结账号
	 * @param userId
	 */
	public void update_freeze(String userId){
		UserBonus userBonus=userBonusDao.find(userId, SqlLock.UPDATE);
		if(userBonus==null){
			throw new RuntimeException("userID["+userId+"]不存在");
		}
		if(userBonus.getBonusStatus()==1){
			return;
		}
		userBonus.setBonusStatus(1);//冻结
		userBonusDao.update(userBonus);
	}
	/**
	 * 冻结账号
	 * @param userId
	 */
	public void update_unfreeze(String userId){
		UserBonus userBonus=userBonusDao.find(userId, SqlLock.UPDATE);
		if(userBonus==null){
			throw new RuntimeException("userID["+userId+"]不存在");
		}
		if(userBonus.getBonusStatus()==0){
			return;
		}
		userBonus.setBonusStatus(0);//解冻
		userBonusDao.update(userBonus);
	}
}
