package com.xunlei.niux.data.activity.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.activity.dto.ActivityDTO;
import com.xunlei.niux.data.activity.dto.ActivitySummaryDTO;
import com.xunlei.niux.data.activity.vo.Activity;
import org.springframework.jdbc.core.RowCallbackHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-6-26.
 */
public class ActivityDaoImpl extends BaseDaoImpl implements ActivityDao {

	
	 public List<Activity> queryActivitys(String keyWord,int limit) {
	        String sql = "select * from activity_activity where   actstatus<>0 and smallPicUrl<>''   and  title like ? ";
	          sql += " order by starttime desc limit "+limit;        
	        final List<Activity> activityList = new ArrayList<Activity>();
	        getJdbcTemplate().query(sql, new Object[]{keyWord+"%"}, new RowCallbackHandler() {
	            @Override
	            public void processRow(ResultSet resultSet) throws SQLException {
	            	Activity activity = new Activity();
	            	activity.setSeqId(resultSet.getLong("seqId"));
	            	activity.setTitle(resultSet.getString("title"));
	            	activity.setLink(resultSet.getString("link"));
	            	activity.setActno(resultSet.getString("actno"));
	            	activityList.add(activity);
	            }
	        });
	        return activityList;
	    }

	 
	 public List<ActivityDTO> queryActivitysByKeyWord(String keyWord) {
	        String sql = "select * from activity_activity as act\n" +
	                "where  act.actstatus<>0 and  act.smallPicUrl<>''  and act.title like ? \n" +
	                "order by act.starttime desc ";
	        final List<ActivityDTO> activityDTOList = new ArrayList<ActivityDTO>();
	        getJdbcTemplate().query(sql, new Object[]{"%"+keyWord+"%"},new RowCallbackHandler() {
	            @Override
	            public void processRow(ResultSet resultSet) throws SQLException {
	                ActivityDTO dto = new ActivityDTO();
	                dto.setActno(resultSet.getString("actno"));
	                dto.setTitle(resultSet.getString("title"));
	                dto.setLink(resultSet.getString("link"));
	                dto.setGameid(resultSet.getString("gameid"));
	                dto.setStarttime(resultSet.getString("starttime"));
	                dto.setEndtime(resultSet.getString("endtime"));
	                dto.setActstatus(resultSet.getString("actstatus"));
	                dto.setPhoto(resultSet.getString("smallPicUrl"));
	                activityDTOList.add(dto);
	            }
	        });

	        return activityDTOList;
	    }
	 
    @Override
    public List<ActivityDTO> getActivityPhotoInfoList(String actLocation, int limit) {
        Object[] args = null;
        String sql = "select * from activity_activity as act\n" +
                "join activity_photo as photo on act.actNo = photo.actNo\n" +
                "where photo.actLocation = ?\n" +
                "and  (photo.validdatetime = '' or photo.validdatetime < now()) and (photo.invaliddatetime = '' or photo.invaliddatetime > now())\n" + 
                "order by photo.displayOrder desc ";
        if(limit > 0 ){
            sql += " limit ?;";
            args = new Object[]{actLocation,limit};
        }else {
            args = new Object[]{actLocation};
        }

        final List<ActivityDTO> activityDTOList = new ArrayList<ActivityDTO>();

        getJdbcTemplate().query(sql,args,new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                ActivityDTO dto = new ActivityDTO();
                dto.setActno(resultSet.getString("actno"));
                dto.setTitle(resultSet.getString("title"));
                dto.setLink(resultSet.getString("link"));
                dto.setGameid(resultSet.getString("gameid"));
                dto.setStarttime(resultSet.getString("starttime"));
                dto.setEndtime(resultSet.getString("endtime"));
                dto.setActstatus(resultSet.getString("actstatus"));
                dto.setActLocation(resultSet.getString("actLocation"));
                dto.setPhoto(resultSet.getString("photo"));
                dto.setLinkUrl(resultSet.getString("linkUrl"));
                dto.setPeopleCount(resultSet.getLong("peopleCount"));
                dto.setActDesc(resultSet.getString("actDesc"));
                dto.setDisplayOrder(resultSet.getInt("displayOrder"));
                dto.setExt1(resultSet.getString("ext1"));
                dto.setExt2(resultSet.getString("ext2"));
                dto.setExt3(resultSet.getString("ext3"));
                activityDTOList.add(dto);
            }
        });

        return activityDTOList;
    }
    
    
    public List<ActivitySummaryDTO> getActivitySummaryList(Activity query ,int pageNo,int pageSize) {        
       List<Object> list = new ArrayList<Object>();      
    	String sql = "select * from activity_activity as s1\n" +
                "left join activity_summary as s2 on s1.actNo = s2.actNo\n" +
                "where 1=1 ";
           String actNo = query.getActno();
	    	if(StringTools.isNotEmpty(actNo)){
	    		sql +=  "and s1.actNo = ?";
	    		list.add(actNo);
	    	}
	    	String gameid = query.getGameid();
	    	if(StringTools.isNotEmpty(gameid)){
	    		sql +=  "and s1.gameid = ?";
	    		list.add(gameid);
	    	}
	    	String manager = query.getManager();
	    	if(StringTools.isNotEmpty(manager)){
	    		sql +=  "and s1.manager = ?";
	    		list.add(manager);
	    	}
	    	String title = query.getTitle();
	    	if(StringTools.isNotEmpty(title)){
	    		sql += " and s1.title=?\n";
	    		list.add(title);
	    	}
	    	Integer checkStatus = query.getCheckStatus();
	    	if(checkStatus!=null){
	    		sql += " and s1.checkStatus=?\n";
	    		list.add(checkStatus);
	    	}
	       list.add((pageNo-1)*pageSize);
	       list.add(pageSize);
           sql+= "order by s1.starttime desc " +
                "limit ?,?";
           
           System.out.println("sql:"+sql);
           System.out.println("sql:"+sql);
           System.out.println("sql:"+sql);
        final List<ActivitySummaryDTO> activityDTOList = new ArrayList<ActivitySummaryDTO>();
        getJdbcTemplate().query(sql,list.toArray(),new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
            	ActivitySummaryDTO dto = new ActivitySummaryDTO();
            	dto.setSeqId(resultSet.getLong("seqid"));
                dto.setActno(resultSet.getString("actno"));
                dto.setTitle(resultSet.getString("title"));
                dto.setDescription(resultSet.getString("description"));
                dto.setLink(resultSet.getString("link"));
                dto.setGameid(resultSet.getString("gameid"));
                dto.setStarttime(resultSet.getString("starttime"));
                dto.setEndtime(resultSet.getString("endtime"));
                dto.setInputTime(resultSet.getString("inputTime"));
                dto.setInputBy(resultSet.getString("inputBy"));
                dto.setEditTime(resultSet.getString("editTime"));
                dto.setEditBy(resultSet.getString("editBy"));
                dto.setActstatus(resultSet.getString("actstatus"));     
                dto.setPicUrl(resultSet.getString("picUrl"));
                dto.setSmallPicUrl(resultSet.getString("smallPicUrl"));
                dto.setDayMaxmoney(resultSet.getDouble("dayMaxmoney"));
                dto.setHalfHourMaxmoney(resultSet.getDouble("halfHourMaxmoney"));
                dto.setActType(resultSet.getInt("actType"));
                dto.setDeleteStatus(resultSet.getInt("deleteStatus"));
                dto.setGameType(resultSet.getInt("gameType"));
                dto.setCheckStatus(resultSet.getInt("checkStatus"));
                dto.setManager(resultSet.getString("manager"));
                dto.setSummaryId(resultSet.getLong("summaryId"));
                dto.setActivityForm(resultSet.getString("activityForm"));
                dto.setActivityPurpose(resultSet.getString("activityPurpose"));
                dto.setSpreadInfo(resultSet.getString("spreadInfo"));
                dto.setExpectMoney(resultSet.getLong("expectMoney"));
                dto.setRealMoney(resultSet.getLong("realMoney"));
                dto.setPv(resultSet.getLong("pv"));
                dto.setUv(resultSet.getLong("uv"));
                dto.setPeopleCount(resultSet.getLong("peopleCount"));
                dto.setDataDesc(resultSet.getString("dataDesc"));
                dto.setActivitySummary(resultSet.getString("activitySummary"));
                dto.setOptimizeWord(resultSet.getString("optimizeWord"));
                dto.setDesigner(resultSet.getString("designer"));
                dto.setRebuilder(resultSet.getString("rebuilder"));
                dto.setCoder(resultSet.getString("coder"));
                dto.setTester(resultSet.getString("tester"));
                dto.setOther(resultSet.getString("other"));
                dto.setAttachment(resultSet.getString("attachment"));
                dto.setRecordTime(resultSet.getString("recordTime"));
                activityDTOList.add(dto);
            }
        });

        return activityDTOList;
    }

    /**
     * 获得所有活动
     */
	@Override
	public List<Activity> getAllActivityList(int gameType) {
		Activity query = new Activity();
		query.setActstatus("1");//正在进行的活动
		if(gameType != 0)
		   query.setGameType(gameType);//指定手游或页游
		Page page = new Page();
		page.addOrder("starttime", OrderType.DESC);//按开始时间逆序		
		return super.findByObject(Activity.class, query, page);
	}
}
