package com.xunlei.niux.data.activity.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FacadeFactory {
	public static final IFacade INSTANCE;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/activity/xml/tomcatjndi.xml","com/xunlei/niux/data/activity/xml/applicationContext.xml"}).getBean("ActivityFacade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/activity/xml/jdbc.xml","com/xunlei/niux/data/activity/xml/applicationContext.xml"}).getBean("ActivityFacade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/activity/xml/springjndi.xml","com/xunlei/niux/data/activity/xml/applicationContext.xml"}).getBean("ActivityFacade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_activity_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
