package com.xunlei.niux.data.activity.bo;

import com.xunlei.niux.data.activity.dao.ActivityDao;
import com.xunlei.niux.data.activity.dto.ActivityDTO;
import com.xunlei.niux.data.activity.dto.ActivitySummaryDTO;
import com.xunlei.niux.data.activity.vo.Activity;

import java.util.List;

/**
 * Created by jamesjxin on 14-6-26.
 */
public class ActivityBoImpl implements ActivityBo {

    private ActivityDao activityDao;

    public ActivityDao getActivityDao() {
        return activityDao;
    }

    public void setActivityDao(ActivityDao activityDao) {
        this.activityDao = activityDao;
    }

    @Override
    public List<ActivityDTO> getActivityPhotoInfoList(String actLocation) {
        return getActivityPhotoInfoList(actLocation, 0);
    }

    @Override
    public List<ActivityDTO> getActivityPhotoInfoList(String actLocation, int limit) {
        return activityDao.getActivityPhotoInfoList(actLocation, limit);
    }
    
    public List<Activity> getAllActivityList(int gameType){
    	return activityDao.getAllActivityList(gameType);
    }

	@Override
	public List<Activity> queryActivitys(String keyWord, int limit) {		
		return activityDao.queryActivitys(keyWord, limit);
	}

	@Override
	public List<ActivityDTO> queryActivitysByKeyWord(String keyWord) {		
		return activityDao.queryActivitysByKeyWord(keyWord);
	}

	@Override
	public List<ActivitySummaryDTO> getActivitySummaryList(Activity query , int pageNo, int pageSize) {	
		return activityDao.getActivitySummaryList(query, pageNo, pageSize);
	}
	
	
}
