/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.common.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;

public class IPUtil {
    public static final String SERVER_ROOM_TW06 = "tw06";
    public static final String SERVER_ROOM_TWIN14 = "twin14";

    public static String getLocalServerRoom() {
        String serverRoom = "";
        String localHostName = IPUtil.getLocalHostName();
        if (StringUtils.isNotBlank((String)localHostName)) {
            if (localHostName.startsWith(SERVER_ROOM_TW06)) {
                serverRoom = SERVER_ROOM_TW06;
            }
            if (localHostName.startsWith(SERVER_ROOM_TWIN14)) {
                serverRoom = SERVER_ROOM_TWIN14;
            }
        }
        return serverRoom;
    }

    public static String getLocalHostName() {
        String hostName = "";
        InetAddress localHost = IPUtil.getLocalHost();
        if (localHost != null) {
            hostName = localHost.getHostName();
        }
        return hostName;
    }

    public static String getLocalHostAddress() {
        String localip = null;
        String netip = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    localip = ip.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (netip != null && !"".equals(netip)) {
            return netip;
        }
        return localip;
    }

    private static InetAddress getLocalHost() {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localHost;
    }
}

