/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.common.handle;

import com.xunlei.netty.cache.JRedisProxy;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPLimitHandle {
    private static Logger logger = LoggerFactory.getLogger((String)IPLimitHandle.class.getName());
    private static final String WHITE_IPS = "183.62.134.65,123.151.31.240,123.151.31.101,183.62.134.65,119.145.40.161,123.150.185.179,111.161.24.179,111.161.24.70,123.150.185.70,119.145.40.161,183.62.134.65,121.35.210.111,219.133.170.82,112.90.220.160,183.2.185.81,202.104.136.196,14.215.129.166,124.127.133.146,219.139.173.82,219.139.173.81,183.93.62.114,183.93.62.113,219.139.173.83,183.93.62.115,219.139.173.84,183.93.62.116,219.139.173.85,183.93.62.117,219.139.173.86,183.93.62.118,219.139.173.87,183.93.62.119,219.139.173.88,183.93.62.120,219.139.173.89,183.93.62.122,61.155.184.215,112.87.43.215,115.238.43.146,121.43.169.187,121.34.128.3";
    private static final int HIT_EXP_TIME = 60;
    private static final int HIT_COUNT = 15;
    private static final int BLACK_IP_EXP_TIME = 86400;
    private static final String IP_LIMIT_PROPERTIES_URL = "ip-limit-handle.properties";
    private String whiteIps;
    private int hitExpTime;
    private int hitCount;
    private int blackIpExpTime;
    private static final IPLimitHandle instance = new IPLimitHandle();
    private Properties config;

    private IPLimitHandle() {
        try {
            InputStream e = JRedisProxy.class.getClassLoader().getResourceAsStream(IP_LIMIT_PROPERTIES_URL);
            if (e != null) {
                this.config = new Properties();
                this.config.load(e);
            }
        }
        catch (Exception var3) {
            System.out.println("jredis system\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25");
            var3.printStackTrace();
            logger.error("JRedisProxy\u521d\u59cb\u5316[JRedisProxy(jredisPropertiesUrl)].\u5f02\u5e38", (Throwable)var3);
        }
    }

    public static IPLimitHandle getInstance() {
        return instance;
    }

    public boolean checkIp(String key, String ip) {
        this.setPropertiesValue(key);
        return this.checkIp(key, ip, this.hitCount, this.whiteIps, this.hitExpTime, this.blackIpExpTime);
    }

    public boolean checkIp(String key, String ip, int hitCount) {
        this.setPropertiesValue(key);
        return this.checkIp(key, ip, hitCount, this.whiteIps, this.hitExpTime, this.blackIpExpTime);
    }

    public boolean checkIp(String key, String ip, int hitCount, String whiteIps) {
        this.setPropertiesValue(key);
        return this.checkIp(key, ip, hitCount, whiteIps, this.hitExpTime, this.blackIpExpTime);
    }

    public boolean checkIp(String key, String ip, int hitCount, String whiteIps, int hitExpTime) {
        this.setPropertiesValue(key);
        return this.checkIp(key, ip, hitCount, whiteIps, hitExpTime, this.blackIpExpTime);
    }

    public boolean checkIp(String key, String ip, int count, String whiteIps, int expTime, int blackIpExpTime) {
        String backIpkey = key + "_" + ip + "_black";
        String ipCountKey = key + "_" + ip + "_count";
        if (!whiteIps.contains(ip)) {
            String backIp = JRedisProxy.getInstance().get(backIpkey);
            if (backIp == null) {
                int hitCount;
                String maxCountStr = JRedisProxy.getInstance().get(ipCountKey);
                int n = hitCount = maxCountStr == null ? 1 : Integer.parseInt(maxCountStr);
                if (hitCount >= count) {
                    JRedisProxy.getInstance().set(backIpkey, ip, blackIpExpTime);
                    return false;
                }
                JRedisProxy.getInstance().set(ipCountKey, String.valueOf(++hitCount), expTime);
            } else {
                return false;
            }
        }
        return true;
    }

    private void setPropertiesValue(String key) {
        if (this.config != null) {
            this.whiteIps = this.config.getProperty("whiteIps") == null ? WHITE_IPS : this.config.getProperty("whiteIps");
            this.hitExpTime = this.config.getProperty(key + ".hitExpTime") == null ? 60 : Integer.parseInt(this.config.getProperty(key + ".hitExpTime"));
            this.hitCount = this.config.getProperty(key + ".hitCount") == null ? 15 : Integer.parseInt(this.config.getProperty(key + ".hitCount"));
            this.blackIpExpTime = this.config.getProperty(key + ".blackIpExpTime") == null ? 86400 : Integer.parseInt(this.config.getProperty(key + ".blackIpExpTime"));
        } else {
            this.whiteIps = WHITE_IPS;
            this.hitExpTime = 60;
            this.hitCount = 15;
            this.blackIpExpTime = 86400;
        }
    }
}

