/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.common.account.cbin;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.xunlei.niux.common.account.cbin.msg.AbstarctEncodeMessage;
import com.xunlei.niux.common.account.cbin.msg.AbstractDecodeMessage;
import com.xunlei.niux.common.account.cbin.msg.DefaultDecodeMessage;
import com.xunlei.niux.common.account.cbin.msg.DefaultMultiRowDecodeMessage;
import com.xunlei.niux.common.account.cbin.msg.DefaultMultiRowEncodeMessage;
import com.xunlei.niux.common.account.cbin.msg.XLCbinMessage;
import com.xunlei.util.CloseableHelper;
import com.xunlei.util.StringTools;
import com.xunlei.util.ValueUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLCbinRecordCodec {
    private static final Charset charset = Charset.forName("GBK");
    private static final Logger log = LoggerFactory.getLogger((String)XLCbinRecordCodec.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractDecodeMessage decode(DataInputStream in, AbstractDecodeMessage decodeResult) throws Exception {
        StringBuilder info = new StringBuilder();
        try {
            int recordLen = in.readInt();
            info.append(recordLen).append("->");
            int remainRecordLen = recordLen - 4;
            boolean mulitRow = decodeResult instanceof DefaultMultiRowDecodeMessage;
            DefaultMultiRowDecodeMessage decodeResultMulti = mulitRow ? (DefaultMultiRowDecodeMessage)decodeResult : null;
            int rowIndex = 0;
            while (remainRecordLen > 0) {
                int fieldLen;
                int rowLen = in.readInt();
                info.append("[").append(rowLen).append(" ");
                remainRecordLen -= 4 + rowLen;
                HashMap<String, String> fieldMap = new HashMap<String, String>();
                for (int remainRowLen = rowLen; remainRowLen > 0; remainRowLen -= 4 + fieldLen) {
                    fieldLen = in.readInt();
                    int nameLen = in.readInt();
                    byte[] name = new byte[nameLen];
                    in.readFully(name);
                    String fieldName = new String(name);
                    int valueLen = in.readInt();
                    if (fieldLen != 8 + nameLen + valueLen) {
                        throw new IllegalStateException("fieldLen != 8 + nameLen + valueLen: fieldLen=" + fieldLen + ",nameLen=" + nameLen + ",valueLen" + valueLen);
                    }
                    byte[] value = new byte[valueLen];
                    in.readFully(value);
                    String filedValue = new String(value, charset);
                    fieldMap.put(fieldName, filedValue);
                    info.append(" ").append(fieldLen).append("|").append(nameLen).append("|").append(fieldName).append(":").append(filedValue);
                }
                info.append("]");
                try {
                    AbstractDecodeMessage r = mulitRow ? decodeResultMulti.getDecodeRow(rowIndex++) : decodeResult;
                    Class<?> clazz = r.getClass();
                    for (Map.Entry entry : fieldMap.entrySet()) {
                        String fieldName = (String)entry.getKey();
                        String fieldValue = (String)entry.getValue();
                        if (StringTools.isEmpty((CharSequence)fieldValue)) continue;
                        try {
                            Field f = clazz.getDeclaredField(fieldName);
                            f.setAccessible(true);
                            if (f.getType() == String.class) {
                                f.set(r, fieldValue);
                                continue;
                            }
                            if (f.getType() == Integer.TYPE) {
                                f.set(r, ValueUtil.getInteger((String)fieldValue, (int)-1));
                                continue;
                            }
                            if (f.getType() == Long.TYPE) {
                                f.set(r, ValueUtil.getLong((String)fieldValue, (long)-1L));
                                continue;
                            }
                            if (f.getType() == Boolean.TYPE) {
                                if (fieldValue.equalsIgnoreCase("true") || fieldValue.equalsIgnoreCase("y") || fieldValue.equals("1")) {
                                    f.set(r, true);
                                    continue;
                                }
                                f.set(r, false);
                                continue;
                            }
                            if (f.getType() == Float.TYPE) {
                                f.set(r, Float.valueOf(ValueUtil.getFloat((String)fieldValue, (float)-1.0f)));
                                continue;
                            }
                            if (f.getType() == Double.TYPE) {
                                f.set(r, ValueUtil.getDouble((String)fieldValue, (double)-1.0));
                                continue;
                            }
                            if (f.getType() == Byte.TYPE) {
                                f.set(r, ValueUtil.getByte((String)fieldValue, (byte)-1));
                                continue;
                            }
                            if (f.getType() != Short.TYPE) continue;
                            f.set(r, ValueUtil.getShort((String)fieldValue, (short)-1));
                        }
                        catch (Exception e) {
                            log.warn("clazz:{},field:{},fieldValue:{}", new Object[]{r.getClass().getSimpleName(), fieldName, fieldValue, e});
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    log.error("fieldMap:{}", fieldMap, (Object)e);
                }
                if (mulitRow) continue;
                if (remainRecordLen <= 0) {
                } else {
                    log.warn("not fully parse resp,remainRecordLen={}", (Object)remainRecordLen);
                }
                break;
            }
        }
        finally {
            decodeResult.setRespMessage(info.toString());
        }
        return decodeResult;
    }

    public static ByteBuffer encode(XLCbinMessage msg) {
        int recordLen = 4;
        if (msg instanceof DefaultMultiRowEncodeMessage) {
            XLCbinMessage[] rows = ((DefaultMultiRowEncodeMessage)msg).getEncodeRows();
            ArrayList<ByteBuffer> rowBufs = new ArrayList<ByteBuffer>(rows.length);
            for (XLCbinMessage r : rows) {
                ByteBuffer rowBuf = XLCbinRecordCodec.encodeRow(r);
                recordLen += rowBuf.capacity();
                rowBufs.add(rowBuf);
            }
            ByteBuffer recordBuf = ByteBuffer.allocate(recordLen);
            recordBuf.putInt(recordLen);
            for (ByteBuffer rowBuf : rowBufs) {
                recordBuf.put(rowBuf);
            }
            return recordBuf;
        }
        ByteBuffer rowBuf = XLCbinRecordCodec.encodeRow(msg);
        ByteBuffer recordBuf = ByteBuffer.allocate(recordLen += rowBuf.capacity());
        recordBuf.putInt(recordLen);
        recordBuf.put(rowBuf.array());
        return recordBuf;
    }

    private static ByteBuffer encodeField(Field f, Object obj) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        if (Map.class.isAssignableFrom(f.getType())) {
            Map map = (Map)f.get(obj);
            Set es = map.entrySet();
            int rowLen = 0;
            ArrayList<ByteBuffer> filedBufs = new ArrayList<ByteBuffer>(map.size());
            for (Map.Entry entry : es) {
                try {
                    String field = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    ByteBuffer fieldBuf = XLCbinRecordCodec.encodeField1(field.getBytes(), value.getBytes());
                    filedBufs.add(fieldBuf);
                    rowLen += fieldBuf.capacity();
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            ByteBuffer allBuf = ByteBuffer.allocate(rowLen);
            for (ByteBuffer filedBuf : filedBufs) {
                allBuf.put(filedBuf.array());
            }
            return allBuf;
        }
        String fieldName = f.getName();
        byte[] name = fieldName.getBytes();
        Object fieldValueObj = f.get(obj);
        String fieldValue = fieldValueObj == null ? "" : fieldValueObj.toString();
        byte[] value = fieldValue.getBytes();
        return XLCbinRecordCodec.encodeField1(name, value);
    }

    private static ByteBuffer encodeField1(byte[] name, byte[] value) {
        int nameLen = name.length;
        int valueLen = value.length;
        int fieldLen = 8 + nameLen + valueLen;
        ByteBuffer fieldBuf = ByteBuffer.allocate(4 + fieldLen);
        fieldBuf.putInt(fieldLen);
        fieldBuf.putInt(nameLen);
        fieldBuf.put(name);
        fieldBuf.putInt(valueLen);
        fieldBuf.put(value);
        return fieldBuf;
    }

    private static ByteBuffer encodeRow(XLCbinMessage r) {
        Class<?> clazz = r.getClass();
        Field[] fields = clazz.getDeclaredFields();
        int rowLen = 0;
        ArrayList<ByteBuffer> filedBufs = new ArrayList<ByteBuffer>(fields.length);
        for (Field f : fields) {
            try {
                ByteBuffer fieldBuf = XLCbinRecordCodec.encodeField(f, r);
                filedBufs.add(fieldBuf);
                rowLen += fieldBuf.capacity();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        ByteBuffer rowBuf = ByteBuffer.allocate(4 + rowLen);
        rowBuf.putInt(rowLen);
        for (ByteBuffer filedBuf : filedBufs) {
            rowBuf.put(filedBuf.array());
        }
        return rowBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String host, int port, int timeout, AbstarctEncodeMessage req, DefaultDecodeMessage resp) {
        Socket client = null;
        DataInputStream in = null;
        DataOutputStream out = null;
        boolean resultOk = false;
        Transaction t = Cat.newTransaction((String)"ThirdParty.Account", (String)req.getRequest());
        Cat.logEvent((String)"ThirdParty.Account.server", (String)host);
        Cat.logEvent((String)"ThirdParty.Account.serverPort", (String)(port + ""));
        Cat.logEvent((String)"ThirdParty.Account.serverTimeout", (String)(timeout + ""));
        t.addData("req", (Object)req.toString());
        try {
            client = new Socket(host, port);
            client.setSoTimeout(timeout);
            out = new DataOutputStream(client.getOutputStream());
            ByteBuffer buffer = XLCbinRecordCodec.encode(req);
            ((OutputStream)out).write(buffer.array());
            ((OutputStream)out).flush();
            in = new DataInputStream(client.getInputStream());
            XLCbinRecordCodec.decode(in, resp);
            t.setStatus("0");
        }
        catch (Exception e) {
            try {
                log.error("", (Throwable)e);
                t.setStatus((Throwable)e);
            }
            catch (Throwable throwable) {
                t.addData("resp", (Object)resp.getRespMessage());
                resultOk = resp.isOk();
                if (resultOk) {
                    log.debug("{}[{}:{}],req:{},result:{}", new Object[]{req.getRequest(), host, port, req, resp.getResult()});
                } else {
                    log.error("{}[{}:{}],req:{},result:{},resp:{}", new Object[]{req.getRequest(), host, port, req, resp.getResult(), resp.getRespMessage()});
                    Cat.logError((String)"\u8d26\u53f7\u5e93\u8bf7\u6c42\u4e0d\u6210\u529f", (Throwable)new Exception(resp.getResultDesc()));
                }
                CloseableHelper.closeSilently((Socket)client);
                t.complete();
                throw throwable;
            }
            t.addData("resp", (Object)resp.getRespMessage());
            resultOk = resp.isOk();
            if (resultOk) {
                log.debug("{}[{}:{}],req:{},result:{}", new Object[]{req.getRequest(), host, port, req, resp.getResult()});
            } else {
                log.error("{}[{}:{}],req:{},result:{},resp:{}", new Object[]{req.getRequest(), host, port, req, resp.getResult(), resp.getRespMessage()});
                Cat.logError((String)"\u8d26\u53f7\u5e93\u8bf7\u6c42\u4e0d\u6210\u529f", (Throwable)new Exception(resp.getResultDesc()));
            }
            CloseableHelper.closeSilently((Socket)client);
            t.complete();
        }
        t.addData("resp", (Object)resp.getRespMessage());
        resultOk = resp.isOk();
        if (resultOk) {
            log.debug("{}[{}:{}],req:{},result:{}", new Object[]{req.getRequest(), host, port, req, resp.getResult()});
        } else {
            log.error("{}[{}:{}],req:{},result:{},resp:{}", new Object[]{req.getRequest(), host, port, req, resp.getResult(), resp.getRespMessage()});
            Cat.logError((String)"\u8d26\u53f7\u5e93\u8bf7\u6c42\u4e0d\u6210\u529f", (Throwable)new Exception(resp.getResultDesc()));
        }
        CloseableHelper.closeSilently((Socket)client);
        t.complete();
    }
}

