/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.common.account;

import com.xunlei.niux.common.account.proxy.UserInfoProxy;
import com.xunlei.niux.common.util.IPUtil;
import com.xunlei.spring.BeanUtil;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class AccountFactory {
    private static final Logger log = LoggerFactory.getLogger((String)AccountFactory.class.getName());
    public static boolean PROXY_TESTING = AccountFactory.isProxyTest();
    private static AccountFactory accountFactory;
    private static AccountFactory accountFactoryTest;
    private ApplicationContext context;
    private UserInfoProxy userInfoProxy;

    public static AccountFactory getInstance() {
        return AccountFactory.getInstance(PROXY_TESTING);
    }

    public static AccountFactory getInstance(boolean test) {
        if (test) {
            if (accountFactoryTest == null) {
                accountFactoryTest = new AccountFactory(test);
            }
            return accountFactoryTest;
        }
        if (accountFactory == null) {
            accountFactory = new AccountFactory(test);
        }
        return accountFactory;
    }

    protected static String getProxyTestUrl() {
        return "/proxyTesting";
    }

    public static boolean isProxyTest() {
        InputStream is = AccountFactory.class.getResourceAsStream(AccountFactory.getProxyTestUrl());
        if (is == null) {
            String info = "AccountFactory Default Mode: RELEASE\nIf you want to use testing mode:put an empty file named 'proxyTesting' in your classpath";
            log.error(info);
            System.err.println(info);
            return false;
        }
        String info = "AccountFactory Default Mode: TESTING";
        log.error(info);
        System.err.println(info);
        return true;
    }

    private AccountFactory(boolean test) {
        String mainXml = "classpath:com/xunlei/niux/common/account/conf/proxyContext.xml";
        String configXml = "";
        if (test) {
            configXml = "classpath:com/xunlei/niux/common/account/conf/configTestContext.xml";
        } else {
            String serverRoom = IPUtil.getLocalServerRoom();
            if (StringUtils.isBlank((String)serverRoom)) {
                serverRoom = "twin14";
            }
            configXml = "classpath:com/xunlei/niux/common/account/conf/configReleaseContext_" + serverRoom + ".xml";
        }
        this.context = new ClassPathXmlApplicationContext(new String[]{mainXml, configXml});
    }

    public UserInfoProxy getUserInfoProxy() {
        if (this.userInfoProxy == null) {
            this.userInfoProxy = (UserInfoProxy)BeanUtil.getTypedBean((ApplicationContext)this.context, UserInfoProxy.class);
        }
        return this.userInfoProxy;
    }
}

