/**
 * 
 */
package com.xunlei.niux.common.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

import org.apache.commons.lang.StringUtils;

/**
 * IP服务器相关辅助类
 * 
 * @author wangcanyi
 *
 */
public class IPUtil {
	/**
	 * tw06机房名
	 */
	public static final String SERVER_ROOM_TW06 = "tw06";
	/**
	 * twin14机房名
	 */
	public static final String SERVER_ROOM_TWIN14 = "twin14";
	
	/**
	 * 获取服务器所在机房
	 * @return
	 */
	public static String getLocalServerRoom(){
		String serverRoom = "";
		String localHostName = getLocalHostName();
		if(StringUtils.isNotBlank(localHostName)){
			if(localHostName.startsWith(SERVER_ROOM_TW06))
				serverRoom = SERVER_ROOM_TW06;
			if(localHostName.startsWith(SERVER_ROOM_TWIN14))
				serverRoom = SERVER_ROOM_TWIN14;
		}
		return serverRoom;
	}

	/**
	 * 获取本机机器名
	 * 
	 * @return
	 */
	public static String getLocalHostName() {
		String hostName = "";
		InetAddress localHost = IPUtil.getLocalHost();
		if (localHost != null)
			hostName = localHost.getHostName();
		return hostName;
	}
	
	/**
	 * 获取本机IP地址
	 * 
	 * @return
	 */
	public static String getLocalHostAddress() {
		String localip = null;// 本地IP，如果没有配置外网IP则返回它
		String netip = null;// 外网IP
		try {
			Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
			InetAddress ip = null;
			boolean finded = false;// 是否找到外网IP
			while (netInterfaces.hasMoreElements() && !finded) {
				NetworkInterface ni = netInterfaces.nextElement();
				Enumeration<InetAddress> address = ni.getInetAddresses();
				while (address.hasMoreElements()) {
					ip = address.nextElement();
					if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {// 外网IP
						netip = ip.getHostAddress();
						finded = true;
						break;
					} else if (ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {// 内网IP
						localip = ip.getHostAddress();
					}
				}
			}
		} catch (Exception e) {
			
		}

		if (netip != null && !"".equals(netip)) {
			return netip;
		} else {
			return localip;
		}
	}

	/**
	 * 获取本机机器信息
	 * 
	 * @return
	 */
	private static InetAddress getLocalHost() {
		InetAddress localHost = null;
		try {
			localHost = InetAddress.getLocalHost();
		} catch (UnknownHostException e) {

		}
		return localHost;
	}
}
