package com.xunlei.niux.common.handle;

import com.xunlei.netty.cache.JRedisProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;
import java.util.Properties;

/**
 * Created by yuwen on 2016/9/29.
 * ip限流处理
 * 原则
 *   1.读取是否有配置文件niux-ip-limit.properties
 *   2.如果没有配置文件，则用默认值
 *   3.如果有配置文件，则读取配置文件，对应key获取值如
 *   key.count
 *   key.white.ips
 *   key.back.ip.exp.time
 *
 */
public class IPLimitHandle {

    private static Logger logger = LoggerFactory.getLogger(IPLimitHandle.class.getName());
    /**
     * ip 白名单
     */
    private final static String WHITE_IPS ="183.62.134.65,123.151.31.240,123.151.31.101,183.62.134.65,119.145.40.161,123.150.185.179,111.161.24.179,111.161.24.70,123.150.185.70,119.145.40.161,183.62.134.65,121.35.210.111,219.133.170.82,112.90.220.160,183.2.185.81,202.104.136.196,14.215.129.166,124.127.133.146,219.139.173.82,219.139.173.81,183.93.62.114,183.93.62.113,219.139.173.83,183.93.62.115,219.139.173.84,183.93.62.116,219.139.173.85,183.93.62.117,219.139.173.86,183.93.62.118,219.139.173.87,183.93.62.119,219.139.173.88,183.93.62.120,219.139.173.89,183.93.62.122,61.155.184.215,112.87.43.215,115.238.43.146,121.43.169.187,121.34.128.3";
    /**
     * 连续请求时间
     */
    private final static int HIT_EXP_TIME=60;
    /**
     * 连续请求次数
     */
    private final static int HIT_COUNT =15;
    /**
     * 封存时间
     */
    private final static int BLACK_IP_EXP_TIME=24*60*60;

    private final static String  IP_LIMIT_PROPERTIES_URL ="ip-limit-handle.properties";


    private String whiteIps;
    private int hitExpTime;
    private int hitCount;
    private int blackIpExpTime;


    private final static  IPLimitHandle instance = new IPLimitHandle();
    private Properties config;
    private IPLimitHandle(){
        try {
            InputStream e = JRedisProxy.class.getClassLoader().getResourceAsStream(IP_LIMIT_PROPERTIES_URL);
            if(e != null) {
                config = new Properties();
                this.config.load(e);
            }
        } catch (Exception var3) {
            System.out.println("jredis system连接初始化失败");
            var3.printStackTrace();
            logger.error("JRedisProxy初始化[JRedisProxy(jredisPropertiesUrl)].异常", var3);
        }
    }
    public static IPLimitHandle getInstance(){
        return instance;
    }

    /**
     *
     * @param key
     */
    public boolean checkIp(String key,String ip){
        setPropertiesValue(key);
        return checkIp( key, ip,hitCount, whiteIps, hitExpTime, blackIpExpTime);
    }

    public boolean checkIp(String key,String ip,int hitCount){
        setPropertiesValue(key);
        return checkIp( key, ip,hitCount, whiteIps, hitExpTime, blackIpExpTime);

    }

    public boolean checkIp(String key,String ip,int hitCount,String whiteIps){
        setPropertiesValue(key);
        return checkIp(key, ip,hitCount, whiteIps, hitExpTime, blackIpExpTime);

    }
    public boolean checkIp(String key,String ip,int hitCount,String whiteIps,int hitExpTime){
        setPropertiesValue(key);
        return checkIp(key, ip,hitCount, whiteIps, hitExpTime, blackIpExpTime);
    }


    /**
     *
     * @param key
     * @param ip
     * @param count     此ip在持续时间内点击次数
     * @param whiteIps  白名单
     * @param expTime   此ip点击持续时间
     * @param blackIpExpTime 此ip封禁持续时间
     * @return
     */
    public boolean checkIp(String key,String ip,int count,String whiteIps,int expTime,int blackIpExpTime){
        String backIpkey =key +"_"+ip+"_black";
        String ipCountKey =key +"_"+ip+"_count";
        int hitCount;
        if(!whiteIps.contains(ip)){
            String backIp = JRedisProxy.getInstance().get(backIpkey);
            if(backIp==null){
                String maxCountStr = JRedisProxy.getInstance().get(ipCountKey);
                hitCount = maxCountStr==null?1:Integer.parseInt(maxCountStr);
                if(hitCount>=count){
                    JRedisProxy.getInstance().set(backIpkey,ip,blackIpExpTime);
                    return false;
                }else{
                    hitCount++;
                    JRedisProxy.getInstance().set(ipCountKey,String.valueOf(hitCount),expTime);
                }
            }else{
                return false;
            }
        }
        return true;

    }


    /**
     * 如果没有properties文件则默认值
     * @param key
     */
    private void setPropertiesValue(String key){
        if(config!=null){
            whiteIps = config.getProperty("whiteIps")==null?WHITE_IPS:config.getProperty("whiteIps");
            hitExpTime = config.getProperty(key+".hitExpTime")==null?HIT_EXP_TIME:Integer.parseInt(config.getProperty(key+".hitExpTime"));
            hitCount = config.getProperty(key+".hitCount")==null?HIT_COUNT:Integer.parseInt(config.getProperty(key+".hitCount"));
            blackIpExpTime = config.getProperty(key+".blackIpExpTime")==null?BLACK_IP_EXP_TIME:Integer.parseInt(config.getProperty(key+".blackIpExpTime"));
        }else{
            whiteIps = WHITE_IPS;
            hitExpTime = HIT_EXP_TIME;
            hitCount = HIT_COUNT;
            blackIpExpTime = BLACK_IP_EXP_TIME;
        }
    }


}
