/**
 * 
 */
package com.xunlei.niux.common.account.proxy;

import org.springframework.stereotype.Service;

import com.xunlei.niux.common.account.bin.req.Req_getuserinfo;
import com.xunlei.niux.common.account.bin.resp.Resp_getuserinfo_base;
import com.xunlei.niux.common.account.cbin.XLCbinRecordCodec;
import com.xunlei.spring.Config;

/**
 * 账号库用户信息
 * 
 * @author wangcanyi
 *
 */
@Service
public class UserInfoProxy {
	@Config("userinfo.host")
	private String host;
	@Config("userinfo.port")
	private int port;
	@Config("userinfo.timeout")
	private int timeout;

	/**
	 * 获取用户基本信息
	 * 
	 * @param userid
	 * @param usertype
	 * @return
	 */
	public Resp_getuserinfo_base getuserinfo_base(String userid, byte usertype) {
		Resp_getuserinfo_base resp = new Resp_getuserinfo_base();
		XLCbinRecordCodec.send(this.host, this.port, this.timeout, new Req_getuserinfo(userid, usertype, Req_getuserinfo.GetuserinfoType.getuserinfo_base),
				resp);
		return resp;
	}

	/**
	 * @return 服务器地址
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @return 服务器端口
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @return 超时时间
	 */
	public int getTimeout() {
		return timeout;
	}
}
