/**
 * 
 */
package com.xunlei.niux.common.account.cbin.msg;

/**
 * 默认解码消息
 * 
 * @author wangcanyi
 *
 */
public abstract class DefaultDecodeMessage extends AbstractDecodeMessage {
	/**
	 * 返回码
	 * 
	 * @return
	 */
	public abstract int getResult();

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.xunlei.niux.common.account.cbin.msg.AbstractDecodeMessage#isOk()
	 */
	public boolean isOk() {
		return getResult() == 200;
	}

	/**
	 * 返回码描述信息
	 * 
	 * @return
	 */
	public String getResultDesc() {
		String desc = "";
		int resultCode = getResult();
		if (resultCode == 200)
			desc = "命令操纵成功";
		if (resultCode == 300)
			desc = "帐号已经存在";
		if (resultCode == 401)
			desc = "协议解析失败";
		if (resultCode == 403)
			desc = "请求参数非法";
		if (resultCode == 404)
			desc = "帐号不存在";
		if (resultCode == 405)
			desc = "该用户号已绑定帐号（绑定时返回）";
		if (resultCode == 406)
			desc = "该帐号已被使用（绑定时返回）";
		if (resultCode == 407)
			desc = "该用户号尚未绑定帐号（解绑时返回）";
		if (resultCode == 408)
			desc = "不允许绑定帐号（绑定时返回）";
		if (resultCode == 410)
			desc = "帐号与帐号类型不匹配";
		if (resultCode == 411)
			desc = "密码格式不对";
		if (resultCode == 412)
			desc = "旧密码错误";
		if (resultCode == 413)
			desc = "不支持的用户类型";
		if (resultCode == 500)
			desc = "内部错误（缓存异常等）";
		if (resultCode == 501)
			desc = "数据库错误";
		if (resultCode == 505)
			desc = " 没有命令权限";
		if (resultCode == 506)
			desc = "ip异常";
		if (resultCode == 507)
			desc = "验证码错误";
		return desc;
	}
}
