/**
 * 
 */
package com.xunlei.niux.common.account.cbin;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.xunlei.niux.common.account.cbin.msg.AbstarctEncodeMessage;
import com.xunlei.niux.common.account.cbin.msg.AbstractDecodeMessage;
import com.xunlei.niux.common.account.cbin.msg.DefaultDecodeMessage;
import com.xunlei.niux.common.account.cbin.msg.DefaultMultiRowDecodeMessage;
import com.xunlei.niux.common.account.cbin.msg.DefaultMultiRowEncodeMessage;
import com.xunlei.niux.common.account.cbin.msg.XLCbinMessage;
import com.xunlei.util.CloseableHelper;
import com.xunlei.util.StringTools;
import com.xunlei.util.ValueUtil;

/**
 * Cbin请求处理类
 * 
 * @author wangcanyi
 *
 */
public class XLCbinRecordCodec {
	private static final Charset charset = Charset.forName("GBK");
	private static final Logger log = LoggerFactory.getLogger(XLCbinRecordCodec.class.getName());

	/**
	 * 内容解码
	 * 
	 * @param in
	 * @param decodeResult
	 * @return
	 * @throws Exception
	 */
	public static AbstractDecodeMessage decode(DataInputStream in, AbstractDecodeMessage decodeResult) throws Exception {
		StringBuilder info = new StringBuilder();
		label810: try {
			int recordLen = in.readInt();
			info.append(recordLen).append("->");
			int remainRecordLen = recordLen - 4;
			boolean mulitRow = decodeResult instanceof DefaultMultiRowDecodeMessage;
			DefaultMultiRowDecodeMessage decodeResultMulti = mulitRow ? (DefaultMultiRowDecodeMessage) decodeResult : null;

			int rowIndex = 0;
			while (remainRecordLen > 0) {
				int rowLen = in.readInt();
				info.append("[").append(rowLen).append(" ");
				int remainRowLen = rowLen;
				remainRecordLen -= 4 + rowLen;

				Map<String, String> fieldMap = new HashMap<String, String>();
				while (remainRowLen > 0) {
					int fieldLen = in.readInt();
					int nameLen = in.readInt();
					byte[] name = new byte[nameLen];
					in.readFully(name);
					String fieldName = new String(name);
					int valueLen = in.readInt();
					if (fieldLen != 8 + nameLen + valueLen) {
						throw new IllegalStateException("fieldLen != 8 + nameLen + valueLen: fieldLen=" + fieldLen + ",nameLen=" + nameLen + ",valueLen"
								+ valueLen);
					}
					byte[] value = new byte[valueLen];
					in.readFully(value);
					String filedValue = new String(value, charset);

					fieldMap.put(fieldName, filedValue);
					remainRowLen -= 4 + fieldLen;
					info.append(" ").append(fieldLen).append("|").append(nameLen).append("|").append(fieldName).append(":").append(filedValue);
				}
				info.append("]");
				try {
					XLCbinMessage r = mulitRow ? decodeResultMulti.getDecodeRow(rowIndex++) : decodeResult;
					Class<?> clazz = r.getClass();
					for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
						String fieldName = (String) entry.getKey();
						String fieldValue = (String) entry.getValue();
						if (!StringTools.isEmpty(fieldValue)) {
							try {
								Field f = clazz.getDeclaredField(fieldName);
								f.setAccessible(true);
								if (f.getType() == String.class) {
									f.set(r, fieldValue);
								} else if (f.getType() == Integer.TYPE) {
									f.set(r, Integer.valueOf(ValueUtil.getInteger(fieldValue, -1)));
								} else if (f.getType() == Long.TYPE) {
									f.set(r, Long.valueOf(ValueUtil.getLong(fieldValue, -1L)));
								} else if (f.getType() == Boolean.TYPE) {
									if ((fieldValue.equalsIgnoreCase("true")) || (fieldValue.equalsIgnoreCase("y")) || (fieldValue.equals("1"))) {
										f.set(r, Boolean.valueOf(true));
									} else {
										f.set(r, Boolean.valueOf(false));
									}
								} else if (f.getType() == Float.TYPE) {
									f.set(r, Float.valueOf(ValueUtil.getFloat(fieldValue, -1.0F)));
								} else if (f.getType() == Double.TYPE) {
									f.set(r, Double.valueOf(ValueUtil.getDouble(fieldValue, -1.0D)));
								} else if (f.getType() == Byte.TYPE) {
									f.set(r, Byte.valueOf(ValueUtil.getByte(fieldValue, (byte) -1)));
								} else if (f.getType() == Short.TYPE) {
									f.set(r, Short.valueOf(ValueUtil.getShort(fieldValue, (short) -1)));
								}
							} catch (Exception e) {
								log.error("clazz:{},field:{},fieldValue:{}", new Object[] { r.getClass().getSimpleName(), fieldName, fieldValue, e });
							}
						}
					}
				} catch (IndexOutOfBoundsException e) {
					log.error("fieldMap:{}", fieldMap, e);
				}
				if (!mulitRow) {
					if (remainRecordLen <= 0) {
						break;
					}
					log.warn("not fully parse resp,remainRecordLen={}", Integer.valueOf(remainRecordLen));
					break label810;
				}
			}
		} finally {
			decodeResult.setRespMessage(info.toString());
		}
		return decodeResult;
	}

	/**
	 * 编码
	 * 
	 * @param msg
	 * @return
	 */
	public static ByteBuffer encode(XLCbinMessage msg) {
		int recordLen = 4;
		if ((msg instanceof DefaultMultiRowEncodeMessage)) {
			XLCbinMessage[] rows = ((DefaultMultiRowEncodeMessage) msg).getEncodeRows();

			List<ByteBuffer> rowBufs = new ArrayList<ByteBuffer>(rows.length);
			for (XLCbinMessage r : rows) {
				ByteBuffer rowBuf = encodeRow(r);
				recordLen += rowBuf.capacity();
				rowBufs.add(rowBuf);
			}
			ByteBuffer recordBuf = ByteBuffer.allocate(recordLen);
			recordBuf.putInt(recordLen);
			for (ByteBuffer rowBuf : rowBufs) {
				recordBuf.put(rowBuf);
			}
			return recordBuf;
		}
		ByteBuffer rowBuf = encodeRow(msg);
		recordLen += rowBuf.capacity();

		ByteBuffer recordBuf = ByteBuffer.allocate(recordLen);
		recordBuf.putInt(recordLen);
		recordBuf.put(rowBuf.array());
		return recordBuf;
	}

	/**
	 * 编码字段
	 * 
	 * @param f
	 * @param obj
	 * @return
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 */
	private static ByteBuffer encodeField(Field f, Object obj) throws IllegalArgumentException, IllegalAccessException {
		f.setAccessible(true);
		if (Map.class.isAssignableFrom(f.getType())) {
			Map map = (Map) f.get(obj);
			Set<Map.Entry> es = map.entrySet();

			int rowLen = 0;
			List<ByteBuffer> filedBufs = new ArrayList<ByteBuffer>(map.size());
			for (Map.Entry entry : es) {
				try {
					String field = entry.getKey().toString();
					String value = entry.getValue().toString();
					ByteBuffer fieldBuf = encodeField1(field.getBytes(), value.getBytes());
					filedBufs.add(fieldBuf);
					rowLen += fieldBuf.capacity();
				} catch (Exception e) {
					log.error("", e);
				}
			}
			ByteBuffer allBuf = ByteBuffer.allocate(rowLen);
			for (ByteBuffer filedBuf : filedBufs) {
				allBuf.put(filedBuf.array());
			}
			return allBuf;
		}
		String fieldName = f.getName();
		byte[] name = fieldName.getBytes();
		Object fieldValueObj = f.get(obj);
		String fieldValue = fieldValueObj == null ? "" : fieldValueObj.toString();
		byte[] value = fieldValue.getBytes();
		return encodeField1(name, value);
	}

	private static ByteBuffer encodeField1(byte[] name, byte[] value) {
		int nameLen = name.length;
		int valueLen = value.length;

		int fieldLen = 8 + nameLen + valueLen;

		ByteBuffer fieldBuf = ByteBuffer.allocate(4 + fieldLen);
		fieldBuf.putInt(fieldLen);

		fieldBuf.putInt(nameLen);
		fieldBuf.put(name);
		fieldBuf.putInt(valueLen);
		fieldBuf.put(value);
		return fieldBuf;
	}

	private static ByteBuffer encodeRow(XLCbinMessage r) {
		Class<?> clazz = r.getClass();
		Field[] fields = clazz.getDeclaredFields();

		int rowLen = 0;
		List<ByteBuffer> filedBufs = new ArrayList<ByteBuffer>(fields.length);
		for (Field f : fields) {
			try {
				ByteBuffer fieldBuf = encodeField(f, r);
				filedBufs.add(fieldBuf);
				rowLen += fieldBuf.capacity();
			} catch (Exception e) {
				log.error("", e);
			}
		}
		ByteBuffer rowBuf = ByteBuffer.allocate(4 + rowLen);
		rowBuf.putInt(rowLen);
		for (ByteBuffer filedBuf : filedBufs) {
			rowBuf.put(filedBuf.array());
		}
		return rowBuf;
	}

	/**
	 * 发送请求
	 * 
	 * @param host
	 * @param port
	 * @param timeout
	 * @param req
	 * @param resp
	 */
	public static void send(String host, int port, int timeout, AbstarctEncodeMessage req, DefaultDecodeMessage resp) {
		Socket client = null;
		DataInputStream in = null;
		OutputStream out = null;
		boolean resultOk = false;
		Transaction t = Cat.newTransaction("ThirdParty.Account", req.getRequest());
		Cat.logEvent("ThirdParty.Account.server", host);
		Cat.logEvent("ThirdParty.Account.serverPort", port + "");
		Cat.logEvent("ThirdParty.Account.serverTimeout", timeout + "");
		t.addData("req", req.toString());
		try {
			client = new Socket(host, port);
			client.setSoTimeout(timeout);

			out = new DataOutputStream(client.getOutputStream());
			ByteBuffer buffer = encode(req);
			out.write(buffer.array());
			out.flush();
			in = new DataInputStream(client.getInputStream());
			decode(in, resp);
			t.setStatus(Message.SUCCESS);
		} catch (Exception e) {
			log.error("", e);
			t.setStatus(e);
		} finally {
			t.addData("resp",resp.getRespMessage());
			resultOk = resp.isOk();
			if (resultOk) {
				log.debug("{}[{}:{}],req:{},result:{}", new Object[] { req.getRequest(), host, Integer.valueOf(port), req, Integer.valueOf(resp.getResult()) });
			} else {
				log.error("{}[{}:{}],req:{},result:{},resp:{}",
						new Object[] { req.getRequest(), host, Integer.valueOf(port), req, Integer.valueOf(resp.getResult()), resp.getRespMessage() });
				Cat.logError("账号库请求不成功", new Exception(resp.getResultDesc()));
			}
			CloseableHelper.closeSilently(client);
			t.complete();
		}
	}
}
