/**
 * 
 */
package com.xunlei.niux.common.account.bin.resp;

import org.apache.commons.lang.StringUtils;

import com.xunlei.niux.common.account.cbin.msg.DefaultDecodeMessage;

/**
 * 用户基本信息
 * 
 * @author wangcanyi
 *
 */
public class Resp_getuserinfo_base extends DefaultDecodeMessage {
	private int result;
	private long userno;
	private String birthday;
	private String city;
	private String country;
	private String nickname;
	private String province;
	private String sex;
	private int state;
	private long usernewno;
	private int usertype;
	private String usrname;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.xunlei.niux.common.account.cbin.msg.DefaultDecodeMessage#getResult()
	 */
	public int getResult() {
		return this.result;
	}

	/**
	 * 用户内部id
	 * 
	 * @return
	 */
	public long getUserno() {
		return this.userno;
	}

	/**
	 * 旧账号名称（当为空时，使用新账号名称）
	 * 
	 * @return
	 */
	public String getUsrname() {
		if (StringUtils.isBlank(this.usrname))
			return this.usernewno + "";
		return this.usrname;
	}

	/**
	 * 新帐号名称
	 * 
	 * @return
	 */
	public long getUsernewno() {
		return this.usernewno;
	}

	/**
	 * 出生日期
	 * 
	 * @return
	 */
	public String getBirthday() {
		return this.birthday;
	}

	/**
	 * 城市
	 * 
	 * @return
	 */
	public String getCity() {
		return this.city;
	}

	/**
	 * 国家
	 * 
	 * @return
	 */
	public String getCountry() {
		return this.country;
	}

	/**
	 * 昵称信息
	 * 
	 * @return
	 */
	public String getNickname() {
		return this.nickname;
	}

	/**
	 * 省份
	 * 
	 * @return
	 */
	public String getProvince() {
		return this.province;
	}

	/**
	 * 性别 u：未知，f：女 m：男
	 * 
	 * @return
	 */
	public String getSex() {
		return this.sex;
	}

	/**
	 * 帐号状态
	 * 
	 * @return
	 */
	public int getState() {
		return this.state;
	}

	/**
	 * 用户类型0: 旧帐号 1：新帐号 2：内部ID 3：身份证号码 4:邮箱 5:手机号 6：安全手机 7：安全资料身份证 8：gameid -1：不确定类型（不包含内部ID）
	 * 
	 * @return
	 */
	public int getUsertype() {
		return this.usertype;
	}

	/**
	 * 用户账号（新账号大于0时，使用新账号，否则使用旧账号）
	 * 
	 * @return
	 */
	public String getUserAccount() {
		if (this.usernewno > 0L) {
			return this.usernewno + "";
		}
		return this.usrname;
	}
}
