/**
 * 
 */
package com.xunlei.niux.common.account;

import java.io.InputStream;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.xunlei.niux.common.account.proxy.UserInfoProxy;
import com.xunlei.niux.common.util.IPUtil;
import com.xunlei.spring.BeanUtil;

/**
 * 账号库工厂
 * 
 * @author wangcanyi
 *
 */
public class AccountFactory {
	private static final Logger log = LoggerFactory.getLogger(AccountFactory.class.getName());
	public static boolean PROXY_TESTING = isProxyTest();
	private static AccountFactory accountFactory;
	private static AccountFactory accountFactoryTest;
	private ApplicationContext context;
	private UserInfoProxy userInfoProxy;

	/**
	 * 获取实例
	 * 
	 * @return
	 */
	public static AccountFactory getInstance() {
		return getInstance(PROXY_TESTING);
	}

	/**
	 * 获取测试
	 * 
	 * @param test 是否测试环境
	 * @return
	 */
	public static AccountFactory getInstance(boolean test) {
		if (test) {
			if (accountFactoryTest == null) {
				accountFactoryTest = new AccountFactory(test);
			}
			return accountFactoryTest;
		} else {
			if (accountFactory == null) {
				accountFactory = new AccountFactory(test);
			}
			return accountFactory;
		}
	}
	
	/**
	 * ProxyTest测试环境文件存放地址
	 * @return
	 */
	protected static String getProxyTestUrl() {
		return "/proxyTesting";
	}

	/**
	 * 是否测试环境
	 * 
	 * @return
	 */
	public static boolean isProxyTest() {
		InputStream is = AccountFactory.class.getResourceAsStream(getProxyTestUrl());
		if (is == null) {
			String info = "AccountFactory Default Mode: RELEASE\nIf you want to use testing mode:put an empty file named 'proxyTesting' in your classpath";
			log.error(info);
			System.err.println(info);
			return false;
		}
		String info = "AccountFactory Default Mode: TESTING";
		log.error(info);
		System.err.println(info);
		return true;
	}

	/**
	 * 构造器
	 * 
	 * @param test 是否测试
	 */
	private AccountFactory(boolean test) {
		String mainXml = "classpath:com/xunlei/niux/common/account/conf/proxyContext.xml";
		String configXml = "";
		if (test) {
			configXml = "classpath:com/xunlei/niux/common/account/conf/configTestContext.xml";
		} else {
			String serverRoom = IPUtil.getLocalServerRoom();
			if (StringUtils.isBlank(serverRoom))// 默认twin14机房
				serverRoom = IPUtil.SERVER_ROOM_TWIN14;
			configXml = "classpath:com/xunlei/niux/common/account/conf/configReleaseContext_" + serverRoom + ".xml";
		}
		this.context = new ClassPathXmlApplicationContext(new String[] { mainXml, configXml });
	}

	/**
	 * 账号库用户信息
	 * 
	 * @return
	 */
	public UserInfoProxy getUserInfoProxy() {
		if (this.userInfoProxy == null) {
			this.userInfoProxy = ((UserInfoProxy) BeanUtil.getTypedBean(this.context, UserInfoProxy.class));
		}
		return this.userInfoProxy;
	}
}
