/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.document;

import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.LocalizedResourceHelper;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractView;

public abstract class AbstractExcelView
extends AbstractView {
    private static final String CONTENT_TYPE = "application/vnd.ms-excel";
    private static final String EXTENSION = ".xls";
    private String url;

    public AbstractExcelView() {
        this.setContentType(CONTENT_TYPE);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    protected boolean generatesDownloadContent() {
        return true;
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HSSFWorkbook workbook;
        if (this.url != null) {
            workbook = this.getTemplateSource(this.url, request);
        } else {
            workbook = new HSSFWorkbook();
            this.logger.debug("Created Excel Workbook from scratch");
        }
        this.buildExcelDocument(model, workbook, request, response);
        response.setContentType(this.getContentType());
        ServletOutputStream out = response.getOutputStream();
        workbook.write((OutputStream)out);
        out.flush();
    }

    protected HSSFWorkbook getTemplateSource(String url, HttpServletRequest request) throws Exception {
        LocalizedResourceHelper helper = new LocalizedResourceHelper(this.getApplicationContext());
        Locale userLocale = RequestContextUtils.getLocale(request);
        Resource inputFile = helper.findLocalizedResource(url, EXTENSION, userLocale);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading Excel workbook from " + inputFile);
        }
        POIFSFileSystem fs = new POIFSFileSystem(inputFile.getInputStream());
        return new HSSFWorkbook(fs);
    }

    protected abstract void buildExcelDocument(Map var1, HSSFWorkbook var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected HSSFCell getCell(HSSFSheet sheet, int row, int col) {
        HSSFCell cell;
        HSSFRow sheetRow = sheet.getRow(row);
        if (sheetRow == null) {
            sheetRow = sheet.createRow(row);
        }
        if ((cell = sheetRow.getCell((short)col)) == null) {
            cell = sheetRow.createCell((short)col);
        }
        return cell;
    }

    protected void setText(HSSFCell cell, String text) {
        cell.setCellType(1);
        cell.setCellValue(text);
    }
}

