/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public abstract class AbstractCachingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver {
    private boolean cache = true;
    private final Map viewCache = new HashMap();

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        if (!this.isCache()) {
            this.logger.warn("View caching is SWITCHED OFF -- DEVELOPMENT SETTING ONLY: This can severely impair performance");
            return this.createView(viewName, locale);
        }
        Object cacheKey = this.getCacheKey(viewName, locale);
        Map map = this.viewCache;
        synchronized (map) {
            View view = (View)this.viewCache.get(cacheKey);
            if (view == null) {
                view = this.createView(viewName, locale);
                this.viewCache.put(cacheKey, view);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Cached view [" + cacheKey + "]");
                }
            }
            return view;
        }
    }

    protected Object getCacheKey(String viewName, Locale locale) {
        return viewName + "_" + locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String viewName, Locale locale) {
        if (!this.cache) {
            this.logger.warn("View caching is SWITCHED OFF -- removal not necessary");
        } else {
            Object cacheKey = this.getCacheKey(viewName, locale);
            Object cachedView = null;
            Map map = this.viewCache;
            synchronized (map) {
                cachedView = this.viewCache.remove(cacheKey);
            }
            if (cachedView == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No cached instance for view '" + cacheKey + "' was found");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Cache for view " + cacheKey + " has been cleared");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.debug("Clearing entire view cache");
        Map map = this.viewCache;
        synchronized (map) {
            this.viewCache.clear();
        }
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        return this.loadView(viewName, locale);
    }

    protected abstract View loadView(String var1, Locale var2) throws Exception;
}

