/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.handler.AbstractDetectingUrlHandlerMapping;
import org.springframework.web.servlet.mvc.support.ControllerTypePredicate;

public abstract class AbstractControllerUrlHandlerMapping
extends AbstractDetectingUrlHandlerMapping {
    private static final String ANNOTATION_PREDICATE_NAME = "org.springframework.web.servlet.mvc.support.AnnotationControllerTypePredicate";
    private ControllerTypePredicate predicate;
    private Set excludedPackages = Collections.singleton("org.springframework.web.servlet.mvc");
    private Set excludedClasses = Collections.EMPTY_SET;

    public AbstractControllerUrlHandlerMapping() {
        this.predicate = JdkVersion.isAtLeastJava15() ? this.instantiateAnnotationPredicate() : new ControllerTypePredicate();
    }

    public void setIncludeAnnotatedControllers(boolean includeAnnotatedControllers) {
        this.predicate = includeAnnotatedControllers ? this.instantiateAnnotationPredicate() : new ControllerTypePredicate();
    }

    public void setExcludedPackages(String[] excludedPackages) {
        this.excludedPackages = excludedPackages != null ? new HashSet<String>(Arrays.asList(excludedPackages)) : Collections.EMPTY_SET;
    }

    public void setExcludedClasses(Class[] excludedClasses) {
        this.excludedClasses = excludedClasses != null ? new HashSet<Class>(Arrays.asList(excludedClasses)) : Collections.EMPTY_SET;
    }

    private ControllerTypePredicate instantiateAnnotationPredicate() {
        try {
            return (ControllerTypePredicate)ClassUtils.forName(ANNOTATION_PREDICATE_NAME, AbstractControllerUrlHandlerMapping.class.getClassLoader()).newInstance();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot load AnnotationControllerTypePredicate", ex);
        }
    }

    protected String[] determineUrlsForHandler(String beanName) {
        Class beanClass = this.getApplicationContext().getType(beanName);
        if (this.isEligibleForMapping(beanName, beanClass)) {
            return this.buildUrlsForHandler(beanName, beanClass);
        }
        return null;
    }

    protected boolean isEligibleForMapping(String beanName, Class beanClass) {
        if (beanClass == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean type could not be determined");
            }
            return false;
        }
        if (this.excludedClasses.contains(beanClass)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean class is explicitly excluded: " + beanClass.getName());
            }
            return false;
        }
        String beanClassName = beanClass.getName();
        Iterator it = this.excludedPackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!beanClassName.startsWith(packageName)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean class is defined in an excluded package: " + beanClass.getName());
            }
            return false;
        }
        return this.isControllerType(beanClass);
    }

    protected boolean isControllerType(Class beanClass) {
        return this.predicate.isControllerType(beanClass);
    }

    protected boolean isMultiActionControllerType(Class beanClass) {
        return this.predicate.isMultiActionControllerType(beanClass);
    }

    protected abstract String[] buildUrlsForHandler(String var1, Class var2);
}

