/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public class DirtiesContextTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(DirtiesContextTestExecutionListener.class);

    public void afterTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Assert.notNull(testMethod, "The test method of the supplied TestContext must not be null");
        boolean dirtiesContext = testMethod.isAnnotationPresent(DirtiesContext.class);
        if (logger.isDebugEnabled()) {
            logger.debug("After test method: context [" + testContext + "], dirtiesContext [" + dirtiesContext + "].");
        }
        if (dirtiesContext) {
            testContext.markApplicationContextDirty();
            testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
        }
    }
}

