/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.AbstractTransactionalSpringContextTests;
import org.springframework.test.jdbc.JdbcTestUtils;

public abstract class AbstractTransactionalDataSourceSpringContextTests
extends AbstractTransactionalSpringContextTests {
    protected JdbcTemplate jdbcTemplate;
    private String sqlScriptEncoding;
    private boolean zappedTables;

    public AbstractTransactionalDataSourceSpringContextTests() {
    }

    public AbstractTransactionalDataSourceSpringContextTests(String name) {
        super(name);
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    protected void deleteFromTables(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            int rowCount = this.jdbcTemplate.update("DELETE FROM " + names[i]);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Deleted " + rowCount + " rows from table " + names[i]);
        }
        this.zappedTables = true;
    }

    protected final void setComplete() {
        if (this.zappedTables) {
            throw new IllegalStateException("Cannot set complete after deleting tables");
        }
        super.setComplete();
    }

    protected int countRowsInTable(String tableName) {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(0) FROM " + tableName);
    }

    protected void executeSqlScript(String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Executing SQL script '" + sqlResourcePath + "'");
        }
        EncodedResource resource = new EncodedResource(this.getApplicationContext().getResource(sqlResourcePath), this.sqlScriptEncoding);
        long startTime = System.currentTimeMillis();
        LinkedList statements = new LinkedList();
        try {
            LineNumberReader lnr = new LineNumberReader(resource.getReader());
            String script = JdbcTestUtils.readScript(lnr);
            char delimiter = ';';
            if (!JdbcTestUtils.containsSqlScriptDelimiters(script, delimiter)) {
                delimiter = '\n';
            }
            JdbcTestUtils.splitSqlScript(script, delimiter, statements);
            Iterator itr = statements.iterator();
            while (itr.hasNext()) {
                String statement = (String)itr.next();
                try {
                    int rowsAffected = this.jdbcTemplate.update(statement);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug(rowsAffected + " rows affected by SQL: " + statement);
                }
                catch (DataAccessException ex) {
                    if (continueOnError) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn("SQL: " + statement + " failed", ex);
                        continue;
                    }
                    throw ex;
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info("Done executing SQL scriptBuilder '" + sqlResourcePath + "' in " + elapsedTime + " ms");
        }
        catch (IOException ex) {
            throw new DataAccessResourceFailureException("Failed to open SQL script '" + sqlResourcePath + "'", ex);
        }
    }
}

