/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import com.xunlei.util.Log;
import java.lang.reflect.Field;
import java.nio.channels.Selector;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.SocketReceiveBufferPool;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.slf4j.Logger;

public class NioWorkerStat {
    private static final Logger log = Log.getLogger();
    public static NioWorker[] workers;
    private static final String workerinfoFmt = "%-30s %-16s %-16s %-16s %-16s\n";
    private static String sampleSelectorStr;

    static {
        sampleSelectorStr = null;
    }

    public static boolean isStarted(NioWorker w) {
        return Boolean.valueOf(NioWorkerStat.getNioWorkerFieldValue(w, "started").toString());
    }

    private static <T> T getNioWorkerFieldValue(NioWorker w, String field) {
        try {
            Field f = w.getClass().getDeclaredField(field);
            f.setAccessible(true);
            return (T)f.get(w);
        }
        catch (Exception e) {
            log.error("", e);
            return null;
        }
    }

    public static Queue<Runnable> getRegisterTaskQueue(NioWorker w) {
        return (Queue)NioWorkerStat.getNioWorkerFieldValue(w, "registerTaskQueue");
    }

    public static Queue<Runnable> getWriteTaskQueue(NioWorker w) {
        return (Queue)NioWorkerStat.getNioWorkerFieldValue(w, "writeTaskQueue");
    }

    public static int getCancelledKeys(NioWorker w) {
        return Integer.valueOf(NioWorkerStat.getNioWorkerFieldValue(w, "cancelledKeys").toString());
    }

    public static int getBossId(NioWorker w) {
        return Integer.valueOf(NioWorkerStat.getNioWorkerFieldValue(w, "bossId").toString());
    }

    public static int getId(NioWorker w) {
        return Integer.valueOf(NioWorkerStat.getNioWorkerFieldValue(w, "id").toString());
    }

    public static AtomicBoolean getWakenUp(NioWorker w) {
        return (AtomicBoolean)NioWorkerStat.getNioWorkerFieldValue(w, "wakenUp");
    }

    public static Selector getSelector(NioWorker w) {
        return (Selector)NioWorkerStat.getNioWorkerFieldValue(w, "selector");
    }

    public static ReadWriteLock getSelectorGuard(NioWorker w) {
        return (ReadWriteLock)NioWorkerStat.getNioWorkerFieldValue(w, "selectorGuard");
    }

    public static SocketReceiveBufferPool getRecvBufferPool(NioWorker w) {
        return (SocketReceiveBufferPool)NioWorkerStat.getNioWorkerFieldValue(w, "recvBufferPool");
    }

    public static SocketSendBufferPool getSendBufferPool(NioWorker w) {
        return (SocketSendBufferPool)NioWorkerStat.getNioWorkerFieldValue(w, "sendBufferPool");
    }

    public static Object getStartStopLock(NioWorker w) {
        return NioWorkerStat.getNioWorkerFieldValue(w, "startStopLock");
    }

    public static Executor getExecutor(NioWorker w) {
        return (Executor)NioWorkerStat.getNioWorkerFieldValue(w, "executor");
    }

    public static Thread getThread(NioWorker w) {
        return (Thread)NioWorkerStat.getNioWorkerFieldValue(w, "thread");
    }

    public static String statNioWorkers() {
        StringBuilder tmp = new StringBuilder();
        int allRegisterTasksNum = 0;
        int allWriteTasksNum = 0;
        tmp.append(NioWorkerStat.getSampleSelectorStr());
        tmp.append("\n");
        tmp.append(String.format(workerinfoFmt, "Running-NioWorker", "RegisterTasks", "WriteTasks", "CancelledKeys", "WakenUp"));
        NioWorker[] nioWorkerArray = workers;
        int n = workers.length;
        int n2 = 0;
        while (n2 < n) {
            NioWorker w = nioWorkerArray[n2];
            if (NioWorkerStat.isStarted(w)) {
                int rSize = NioWorkerStat.getRegisterTaskQueue(w).size();
                int wSize = NioWorkerStat.getWriteTaskQueue(w).size();
                allRegisterTasksNum += rSize;
                allWriteTasksNum += wSize;
                int cancelledKeys = NioWorkerStat.getCancelledKeys(w);
                String name = "New I/O server worker #" + NioWorkerStat.getBossId(w) + "-" + NioWorkerStat.getId(w);
                tmp.append(String.format(workerinfoFmt, name, rSize > 0 ? Integer.valueOf(rSize) : "", wSize > 0 ? Integer.valueOf(wSize) : "", cancelledKeys > 0 ? Integer.valueOf(cancelledKeys) : "", NioWorkerStat.getWakenUp(w).get() ? "Y" : ""));
            }
            ++n2;
        }
        StringBuilder head = new StringBuilder();
        head.append("\u5f53\u524dNioWorker\u6570 :\t\t").append(workers.length).append("\n");
        head.append("\u8981\u8fd0\u884c\u7684RegisterTasks:\t\t").append(allRegisterTasksNum).append("\n");
        head.append("\u8981\u8fd0\u884c\u7684WriteTasks:\t\t").append(allWriteTasksNum).append("\n");
        head.append("\n");
        tmp.insert(0, head);
        return tmp.toString();
    }

    public static String statNioWorkersAll() {
        StringBuilder tmp = new StringBuilder();
        int allRegisterTasksNum = 0;
        int allWriteTasksNum = 0;
        NioWorker[] nioWorkerArray = workers;
        int n = workers.length;
        int n2 = 0;
        while (n2 < n) {
            NioWorker w = nioWorkerArray[n2];
            if (NioWorkerStat.isStarted(w)) {
                int wSize;
                tmp.append("New I/O server worker #").append(NioWorkerStat.getBossId(w)).append("-").append(NioWorkerStat.getId(w)).append("\n");
                int rSize = NioWorkerStat.getRegisterTaskQueue(w).size();
                if (rSize > 0) {
                    allRegisterTasksNum += rSize;
                    tmp.append("\u8981\u8fd0\u884c\u7684RegisterTasks:").append(rSize).append("\n");
                }
                if ((wSize = NioWorkerStat.getWriteTaskQueue(w).size()) > 0) {
                    allWriteTasksNum += wSize;
                    tmp.append("\u8981\u8fd0\u884c\u7684WriteTasks:").append(wSize).append("\n");
                }
                if (NioWorkerStat.getCancelledKeys(w) > 0) {
                    tmp.append("CancelledKeys:").append(NioWorkerStat.getCancelledKeys(w)).append("\n");
                }
                if (NioWorkerStat.getWakenUp(w).get()) {
                    tmp.append("WakenUp:").append("true").append("\n");
                }
                tmp.append("RegisterTaskQueue:").append(NioWorkerStat.getRegisterTaskQueue(w)).append("\n");
                tmp.append("WriteTaskQueue:").append(NioWorkerStat.getWriteTaskQueue(w)).append("\n");
                tmp.append("Selector:").append(NioWorkerStat.getSelector(w)).append("\n");
                tmp.append("SelectorGuard:").append(NioWorkerStat.getSelectorGuard(w)).append("\n");
                tmp.append("RecvBufferPool:").append(NioWorkerStat.getRecvBufferPool(w)).append("\n");
                tmp.append("SendBufferPool:").append(NioWorkerStat.getSendBufferPool(w)).append("\n");
                tmp.append("StartStopLock:").append(NioWorkerStat.getStartStopLock(w)).append("\n");
                tmp.append("Executor:").append(NioWorkerStat.getExecutor(w)).append("\n");
                tmp.append("Thread:").append(NioWorkerStat.getThread(w)).append("\n");
                tmp.append("\n");
            }
            ++n2;
        }
        StringBuilder head = new StringBuilder();
        head.append("\u5f53\u524dNioWorker\u6570 :\t\t").append(workers.length).append("\n");
        head.append("\u8981\u8fd0\u884c\u7684RegisterTasks:\t\t").append(allRegisterTasksNum).append("\n");
        head.append("\u8981\u8fd0\u884c\u7684WriteTasks:\t\t").append(allWriteTasksNum).append("\n");
        head.append("\n");
        tmp.insert(0, head);
        return tmp.toString();
    }

    private static String getSampleSelectorStr() {
        if (sampleSelectorStr == null && workers.length > 0) {
            StringBuilder tmp = new StringBuilder();
            NioWorker sample = workers[0];
            Selector s = NioWorkerStat.getSelector(sample);
            ReadWriteLock rwl = NioWorkerStat.getSelectorGuard(sample);
            if (s != null) {
                tmp.append("Selector:\t\t\t").append(s.getClass().getName()).append("\n");
            }
            if (rwl != null) {
                tmp.append("SelectorGuard:\t\t\t").append(rwl.getClass().getName()).append("\n");
            }
            sampleSelectorStr = tmp.toString();
        }
        return sampleSelectorStr;
    }

    public static void registerNioWorkers(ServerSocketChannelFactory serverSocketChannelFactory) {
        try {
            Field f = serverSocketChannelFactory.getClass().getDeclaredField("sink");
            f.setAccessible(true);
            Object sink = f.get(serverSocketChannelFactory);
            Field f1 = sink.getClass().getDeclaredField("workers");
            f1.setAccessible(true);
            workers = (NioWorker[])f1.get(sink);
        }
        catch (Exception e) {
            log.error("", e);
        }
    }
}

