/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.concurrent;

import com.xunlei.util.DateUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringHelper;
import com.xunlei.util.StringTools;
import java.text.DateFormat;
import java.util.Date;
import org.slf4j.Logger;

public abstract class BaseRunnable
implements Runnable {
    protected Date lastBeginTime = null;
    protected Date lastEndTime = null;
    protected long lastSpan = -1L;
    protected Throwable lastThrowable = null;
    protected final Logger log = Log.getLogger(this.getClass().getName());
    protected String name = this.log.getName();

    public void afterProcess() {
        if (this.lastThrowable == null) {
            this.log.info("END   run {},USING {} MS...", new Object[]{this.name, this.lastSpan});
        } else {
            this.log.error("END   run {},USING {} MS...", new Object[]{this.name, this.lastSpan, this.lastThrowable});
        }
    }

    public void beforeProcess() {
        this.log.debug("BEGIN run {}...", (Object)this.name);
    }

    public String getLastBeginTimeStr() {
        DateFormat df = DateUtil.DEFAULT_DF_FACOTRY.get();
        return this.lastBeginTime == null ? "" : df.format(this.lastBeginTime);
    }

    public String getLastEndTimeStr() {
        DateFormat df = DateUtil.DEFAULT_DF_FACOTRY.get();
        return this.lastEndTime == null ? "" : df.format(this.lastEndTime);
    }

    public String getLastThrowableStr() {
        return this.lastThrowable == null ? "" : StringHelper.printThrowable(this.lastThrowable).toString();
    }

    public String getExtendInfo() {
        return null;
    }

    public abstract void process() throws Throwable;

    @Override
    public synchronized void run() {
        Date begin = new Date();
        Throwable ex = null;
        try {
            this.beforeProcess();
            this.process();
        }
        catch (Throwable e) {
            ex = e;
        }
        Date end = new Date();
        this.lastBeginTime = begin;
        this.lastEndTime = end;
        this.lastSpan = end.getTime() - begin.getTime();
        this.lastThrowable = ex;
        try {
            this.afterProcess();
        }
        catch (Throwable e) {
            this.log.error("", e);
        }
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        tmp.append(this.name);
        tmp.append(":lastBeginTime=");
        tmp.append(this.getLastBeginTimeStr());
        tmp.append(",lastSpan=");
        tmp.append(this.lastSpan);
        String ext = this.getExtendInfo();
        if (StringTools.isNotEmpty(ext)) {
            tmp.append(",");
            tmp.append(ext);
        }
        if (this.lastThrowable != null) {
            tmp.append("\n");
            StringHelper.printThrowable(tmp, this.lastThrowable);
        }
        return tmp.toString();
    }
}

