/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.codec.crypt;

import java.util.HashSet;

public class SecretHex {
    public static final char[] DIGITS_NORMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private char[] digitsSecret;
    private char[] digits_table_nor2sec;
    private char[] digits_table_sec2nor;

    public static void main(String[] args) {
        char[] keys_sect = new char[]{'4', '7', 'a', '1', '9', '6', '2', 'e', 'd', '8', 'b', '5', 'c', 'f', '3', '0'};
        SecretHex sh = new SecretHex(keys_sect);
        System.out.println(sh.sec2nor("0123456789abcdef"));
        System.out.println(sh.nor2sec("0123456789abcdef"));
        System.out.println(sh.sec2nor(sh.nor2sec("0123456789abcdef")));
        System.out.println(sh.nor2sec(sh.sec2nor("0123456789abcdef")));
    }

    public SecretHex(char[] digitsSecret) {
        char index;
        char c;
        if (digitsSecret.length != DIGITS_NORMAL.length) {
            throw new IllegalArgumentException("digitsSecret's len is not " + DIGITS_NORMAL.length);
        }
        this.digitsSecret = digitsSecret;
        HashSet<Character> checkSet = new HashSet<Character>(DIGITS_NORMAL.length);
        int i = 0;
        while (i < digitsSecret.length) {
            Character c2 = Character.valueOf(digitsSecret[i]);
            if (c2.charValue() < '0' || c2.charValue() > '9' && c2.charValue() < 'a' || c2.charValue() > 'f') {
                throw new IllegalArgumentException("digitsSecret's char[" + i + "] is not hex:" + c2);
            }
            if (checkSet.contains(c2)) {
                throw new IllegalArgumentException("digitsSecret's char[" + i + "] is duplicate:" + c2);
            }
            checkSet.add(c2);
            ++i;
        }
        int table_len = 103;
        this.digits_table_nor2sec = new char[table_len];
        this.digits_table_sec2nor = new char[table_len];
        int i2 = 0;
        while (i2 < DIGITS_NORMAL.length) {
            c = digitsSecret[i2];
            index = DIGITS_NORMAL[i2];
            this.digits_table_nor2sec[index] = c;
            ++i2;
        }
        i2 = 0;
        while (i2 < digitsSecret.length) {
            c = DIGITS_NORMAL[i2];
            index = digitsSecret[i2];
            this.digits_table_sec2nor[index] = c;
            ++i2;
        }
    }

    public char[] getDigitsSecret() {
        return this.digitsSecret;
    }

    public char nor2sec(char nor) {
        return this.digits_table_nor2sec[nor];
    }

    public String nor2sec(String nor) {
        char[] sec = new char[nor.length()];
        int i = 0;
        while (i < sec.length) {
            sec[i] = this.digits_table_nor2sec[nor.charAt(i)];
            ++i;
        }
        return new String(sec);
    }

    public char sec2nor(char sec) {
        return this.digits_table_sec2nor[sec];
    }

    public String sec2nor(String sec) {
        char[] nor = new char[sec.length()];
        int i = 0;
        while (i < nor.length) {
            nor[i] = this.digits_table_sec2nor[sec.charAt(i)];
            ++i;
        }
        return new String(nor);
    }
}

