/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util.codec.crypt;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSACrypt {
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private Cipher cipher = Cipher.getInstance("RSA");

    public void genKeyPairs(int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(keysize);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPrivateKeyBytes() {
        if (this.privateKey != null) {
            return this.privateKey.getEncoded();
        }
        return null;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKey(byte[] privateKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        this.privateKey = keyFactory.generatePrivate(keySpec);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPublicKeyBytes() {
        if (this.publicKey != null) {
            return this.publicKey.getEncoded();
        }
        return null;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setPublicKey(byte[] publicKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        this.publicKey = keyFactory.generatePublic(keySpec);
    }

    public byte[] encodeUsePrivateKey(byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.cipher.init(1, this.privateKey);
        return this.cipher.doFinal(input);
    }

    public byte[] encodeUsePublicKey(byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.cipher.init(1, this.publicKey);
        return this.cipher.doFinal(input);
    }

    public byte[] decodeUsePrivateKey(byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.cipher.init(2, this.privateKey);
        return this.cipher.doFinal(input);
    }

    public byte[] decodeUsePublicKey(byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.cipher.init(2, this.privateKey);
        return this.cipher.doFinal(input);
    }
}

