/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.util;

import com.xunlei.util.MapUtil;
import com.xunlei.util.codec.Hex;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Map;

public class StringHelper {
    private static Method getOurStackTrace;

    static {
        try {
            getOurStackTrace = Throwable.class.getDeclaredMethod("getOurStackTrace", new Class[0]);
            getOurStackTrace.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static StringBuilder append(StringBuilder tmp, Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            tmp.append(s);
            ++n2;
        }
        return tmp;
    }

    public static String concate(Object ... args) {
        if (args.length < 4) {
            String result = "";
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                result = String.valueOf(result) + s;
                ++n2;
            }
            return result;
        }
        return StringHelper.append(new StringBuilder(), args).toString();
    }

    public static <K, V> String concateKeyValue(KeyValueStringBuilder keyValueStringBuilder, Map<K, V> keyvalue) {
        return StringHelper.concateKeyValue(new StringBuilder(), keyValueStringBuilder, keyvalue).toString();
    }

    public static String concateKeyValue(KeyValueStringBuilder keyValueStringBuilder, Object ... keyvalue) {
        return StringHelper.concateKeyValue(new StringBuilder(), keyValueStringBuilder, keyvalue).toString();
    }

    public static <K, V> StringBuilder concateKeyValue(StringBuilder tmp, KeyValueStringBuilder keyValueStringBuilder, Map<K, V> keyvalue) {
        for (Map.Entry<K, V> entry : keyvalue.entrySet()) {
            keyValueStringBuilder.append(tmp, entry.getKey(), entry.getValue());
        }
        return tmp;
    }

    public static StringBuilder concateKeyValue(StringBuilder tmp, KeyValueStringBuilder keyValueStringBuilder, Object ... keyvalue) {
        MapUtil.checkKeyValueLength(keyvalue);
        int i = 0;
        while (i < keyvalue.length) {
            keyValueStringBuilder.append(tmp, keyvalue[i++], keyvalue[i]);
            ++i;
        }
        return tmp;
    }

    public static String concateWithSplit(String splitStr, Object ... args) {
        return StringHelper.concateWithSplit(new StringBuilder(), splitStr, args).toString();
    }

    public static StringBuilder concateWithSplit(StringBuilder tmp, String splitStr, Object ... args) {
        if (args.length == 0) {
            return tmp;
        }
        int endIndex = args.length - 1;
        int i = 0;
        while (i < endIndex) {
            tmp.append(args[i]).append(splitStr);
            ++i;
        }
        tmp.append(args[endIndex]);
        return tmp;
    }

    public static StringBuilder emphasizeTitle(String title, char corner, char linechar, char verticalchar) {
        return StringHelper.emphasizeTitle(new StringBuilder(), title, corner, linechar, verticalchar);
    }

    public static StringBuilder emphasizeTitle(StringBuilder tmp, String title, char corner, char linechar, char verticalchar) {
        try {
            StringBuilder line = StringHelper.printLine(title.getBytes("GBK").length, corner, linechar);
            tmp.append((CharSequence)line);
            tmp.append(verticalchar).append(title).append(verticalchar).append('\n');
            tmp.append((CharSequence)line);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return tmp;
    }

    private static StackTraceElement[] getOurStackTrace(Throwable ex) {
        try {
            StackTraceElement[] ste = (StackTraceElement[])getOurStackTrace.invoke((Object)ex, new Object[0]);
            return ste;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StringBuilder printLine(int len, char linechar) {
        return StringHelper.printLine(new StringBuilder(), len, linechar);
    }

    public static StringBuilder printLine(int len, char corner, char linechar) {
        return StringHelper.printLine(new StringBuilder(), len, corner, linechar);
    }

    public static StringBuilder printLine(StringBuilder tmp, int len, char linechar) {
        int i = 0;
        while (i < len) {
            tmp.append(linechar);
            ++i;
        }
        tmp.append('\n');
        return tmp;
    }

    public static StringBuilder printLine(StringBuilder tmp, int len, char corner, char linechar) {
        tmp.append(corner);
        int i = 0;
        while (i < len) {
            tmp.append(linechar);
            ++i;
        }
        tmp.append(corner);
        tmp.append('\n');
        return tmp;
    }

    public static StringBuilder printThrowable(StringBuilder tmp, Throwable ex) {
        if (ex != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter);
            ex.printStackTrace(pw);
            tmp.append(stringWriter).append('\n');
        }
        return tmp;
    }

    public static StringBuilder printThrowable(Throwable ex) {
        return StringHelper.printThrowable(new StringBuilder(), ex);
    }

    public static String printThrowableSimple(Throwable ex) {
        return StringHelper.printThrowableSimple(ex, 8);
    }

    public static String printThrowableSimple(Throwable ex, int maxTraceLen) {
        if (ex != null) {
            StackTraceElement[] trace;
            StringBuilder s = new StringBuilder();
            s.append(ex.getClass().getSimpleName());
            s.append(":");
            s.append(ex.getMessage());
            if (maxTraceLen > 0 && (trace = StringHelper.getOurStackTrace(ex)) != null) {
                int len = Math.min(trace.length, maxTraceLen);
                int i = 0;
                while (i < len) {
                    try {
                        StackTraceElement t = trace[i];
                        String clazzName = t.getClassName();
                        clazzName = clazzName.substring(clazzName.lastIndexOf(".") + 1, clazzName.length());
                        s.append("||");
                        s.append(clazzName);
                        s.append(".");
                        s.append(t.getMethodName());
                        s.append(":");
                        s.append(t.getLineNumber());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            return s.toString();
        }
        return "";
    }

    public static String printHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(bytes.length);
        int startIndex = 0;
        int column = 0;
        int i = 0;
        while (i < bytes.length) {
            column = i % 16;
            switch (column) {
                case 0: {
                    startIndex = i;
                    StringHelper.fixHexString(buffer, Integer.toHexString(i), 8).append(": ");
                    buffer.append(StringHelper.toHex(bytes[i]));
                    buffer.append(" ");
                    break;
                }
                case 15: {
                    buffer.append(StringHelper.toHex(bytes[i]));
                    buffer.append(" ");
                    buffer.append(StringHelper.filterString(bytes, startIndex, column + 1));
                    buffer.append("\n");
                    break;
                }
                default: {
                    buffer.append(StringHelper.toHex(bytes[i]));
                    buffer.append(" ");
                }
            }
            ++i;
        }
        if (column != 15) {
            i = 0;
            while (i < 15 - column) {
                buffer.append("   ");
                ++i;
            }
            buffer.append(StringHelper.filterString(bytes, startIndex, column + 1));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static StringBuilder fixHexString(StringBuilder buf, String hexStr, int length) {
        if (hexStr == null || hexStr.length() == 0) {
            buf.append("00000000h");
        } else {
            int strLen = hexStr.length();
            int i = 0;
            while (i < length - strLen) {
                buf.append("0");
                ++i;
            }
            buf.append(hexStr).append("h");
        }
        return buf;
    }

    private static String toHex(byte b) {
        char[] buf = new char[2];
        byte bt = b;
        int i = 0;
        while (i < 2) {
            buf[1 - i] = Hex.DIGITS_LOWER[bt & 0xF];
            bt = (byte)(bt >>> 4);
            ++i;
        }
        return new String(buf);
    }

    private static String filterString(byte[] bytes, int offset, int count) {
        byte[] buffer = new byte[count];
        System.arraycopy(bytes, offset, buffer, 0, count);
        int i = 0;
        while (i < count) {
            if (buffer[i] >= 0 && buffer[i] <= 31) {
                buffer[i] = 46;
            }
            ++i;
        }
        return new String(buffer);
    }

    private StringHelper() {
    }

    public static interface KeyValueStringBuilder {
        public void append(StringBuilder var1, Object var2, Object var3);
    }
}

