/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.util;

public class StringIterator {
    private String source;
    private int position = 0;
    private int size;

    public StringIterator(String source) {
        this.source = source;
        if (source != null) {
            this.size = source.length();
        }
    }

    public boolean isEnd() {
        if (this.source == null) {
            return true;
        }
        return this.position >= this.size - 1;
    }

    public String nextSubString(int length) {
        if (length <= 0) {
            return null;
        }
        if (this.isEnd()) {
            return null;
        }
        String sub = null;
        int nextPosition = this.position + length;
        sub = nextPosition >= this.size ? this.source.substring(this.position) : this.source.substring(this.position, nextPosition);
        this.position = nextPosition;
        return sub;
    }

    public String lastSubString() {
        if (this.isEnd()) {
            return null;
        }
        return this.source.substring(this.position);
    }

    public String nextChar() {
        if (this.position >= this.size) {
            return null;
        }
        return this.source.substring(this.position, this.position++ + 1);
    }
}

