/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6772475949708094767L;
    private HashMap<K, V> keyToValue;
    private HashMap<V, K> valueToKey;
    private HashMap<K, Long> timeMap;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_SIZE = 16;

    public BiHashMap(int initialCapacity, float loadFactor) {
        this.keyToValue = new HashMap(initialCapacity, loadFactor);
        this.valueToKey = new HashMap(initialCapacity, loadFactor);
        this.timeMap = new HashMap(initialCapacity, loadFactor);
    }

    public BiHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public BiHashMap(Map<? extends K, ? extends V> m) {
        this();
        this.putAll(m);
    }

    private BiHashMap(HashMap<K, V> keyToValue, HashMap<V, K> valueToKey, HashMap<K, Long> timeMap) {
        this.keyToValue = keyToValue;
        this.valueToKey = valueToKey;
        this.timeMap = timeMap;
    }

    public BiHashMap() {
        this(16, 0.75f);
    }

    @Override
    public void clear() {
        this.keyToValue.clear();
        this.valueToKey.clear();
    }

    @Override
    public Object clone() {
        BiHashMap<K, V> result = new BiHashMap<K, V>((HashMap)this.keyToValue.clone(), (HashMap)this.valueToKey.clone(), (HashMap)this.timeMap.clone());
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValue.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keyToValue.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.keyToValue.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BiHashMap)) {
            return false;
        }
        BiHashMap map = (BiHashMap)o;
        return this.keyToValue.equals(map.keyToValue) && this.valueToKey.equals(map.valueToKey);
    }

    @Override
    public V get(Object key) {
        return this.keyToValue.get(key);
    }

    public K getKeyByValue(V value) {
        return this.valueToKey.get(value);
    }

    public long getUpdateTime(K key) {
        Long time = this.timeMap.get(key);
        if (time != null) {
            return time;
        }
        return 0L;
    }

    public void updateTime(K key) {
        if (this.timeMap.containsKey(key)) {
            this.timeMap.put(key, System.currentTimeMillis());
        }
    }

    @Override
    public int hashCode() {
        return this.keyToValue.hashCode() + this.valueToKey.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValue.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.keyToValue.keySet();
    }

    @Override
    public synchronized V put(K key, V value) {
        V v = this.keyToValue.put(key, value);
        this.valueToKey.put(value, key);
        this.timeMap.put(key, System.currentTimeMillis());
        return v;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        this.keyToValue.putAll(m);
        for (K k : m.keySet()) {
            V v = m.get(k);
            this.valueToKey.put(v, k);
            this.timeMap.put(k, System.currentTimeMillis());
        }
    }

    @Override
    public synchronized V remove(Object key) {
        V v = this.keyToValue.remove(key);
        if (v != null) {
            this.valueToKey.remove(v);
        }
        this.timeMap.remove(key);
        return v;
    }

    @Override
    public int size() {
        return this.keyToValue.size();
    }

    @Override
    public String toString() {
        return this.keyToValue.toString();
    }

    @Override
    public Collection<V> values() {
        return this.keyToValue.values();
    }
}

