/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.server.common.socketpool;

import com.xunlei.server.common.socketpool.XLSocket;
import com.xunlei.server.common.socketpool.XLSocketPoolConfig;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.log4j.Logger;

public class XLSocketPoolObjectFactory
extends BasePoolableObjectFactory {
    private Logger logger = Logger.getLogger(XLSocketPoolObjectFactory.class);
    private XLSocketPoolConfig config;

    public XLSocketPoolObjectFactory(XLSocketPoolConfig config2) {
        this.config = config2;
    }

    public Object makeObject() throws Exception {
        XLSocket socket = new XLSocket(this.config.getServer(), this.config.getPort());
        socket.setTimeout(this.config.getTimeoutMillis());
        this.logger.info("Open Socket to " + this.config.getServer() + ":" + this.config.getPort());
        return socket;
    }

    public void destroyObject(Object arg0) throws Exception {
        XLSocket socket = (XLSocket)arg0;
        try {
            socket.close();
            this.logger.info("Closed socket to " + this.config.getServer() + ":" + this.config.getPort());
        }
        catch (Exception e) {
            this.logger.error("close socket failed!", e);
        }
        super.destroyObject(arg0);
    }

    public boolean validateObject(Object arg0) {
        XLSocket socket = (XLSocket)arg0;
        if (socket.isClosed()) {
            return false;
        }
        if (!socket.isConnected()) {
            return false;
        }
        if (!socket.isOK()) {
            return false;
        }
        return super.validateObject(arg0);
    }

    public void activateObject(Object arg0) throws Exception {
        XLSocket socket = (XLSocket)arg0;
        socket.setTimeout(this.config.getTimeoutMillis());
        super.activateObject(arg0);
    }

    public void passivateObject(Object arg0) throws Exception {
        super.passivateObject(arg0);
    }
}

