/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.socket.std;

import com.xunlei.proxy.socket.std.XLStandardCodecConfig;
import com.xunlei.proxy.socket.std.msg.HeaderContentSplit;
import com.xunlei.proxy.socket.std.msg.XLMessage;
import com.xunlei.proxy.socket.std.msg.XLMessageHeader;
import com.xunlei.proxy.socket.std.msg.XLMessageStruct;
import com.xunlei.util.EmptyChecker;
import com.xunlei.util.codec.crypt.AESCryptUtil;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class XLEncoderHelper {
    private XLEncoderHelper() {
    }

    public static void writeString(String value, ChannelBuffer cb, XLStandardCodecConfig config) {
        if (value == null) {
            cb.writeInt(0);
        } else {
            byte[] bytes = value.getBytes(config.getStringCharset());
            cb.writeInt(bytes.length);
            cb.writeBytes(bytes);
        }
    }

    public static void writeStruct(XLMessageStruct struct, ChannelBuffer cb, XLStandardCodecConfig config) throws Exception {
        if (struct == null) {
            cb.writeInt(0);
        } else if (config.isLixianCodec()) {
            XLEncoderHelper.writeObject(struct, cb, config);
        } else {
            ChannelBuffer structCb = ChannelBuffers.dynamicBuffer(config.getEndian(), 64);
            XLEncoderHelper.writeObject(struct, structCb, config);
            int len = structCb.writerIndex();
            cb.writeInt(len);
            cb.writeBytes(structCb);
        }
    }

    public static void writeArray(Collection<?> collection, ChannelBuffer cb, XLStandardCodecConfig config) throws Exception {
        if (collection == null || collection.isEmpty()) {
            if (config.isLixianCodec()) {
                cb.writeLong(0L);
            } else {
                cb.writeInt(0);
            }
        } else {
            ChannelBuffer arrayCb = ChannelBuffers.dynamicBuffer(config.getEndian(), 64);
            if (config.isLixianCodec()) {
                arrayCb.writeLong(collection.size());
            } else {
                arrayCb.writeInt(collection.size());
            }
            Object sample = collection.iterator().next();
            Class<?> type = sample.getClass();
            if (type == String.class) {
                for (Object obj : collection) {
                    XLEncoderHelper.writeString(obj.toString(), arrayCb, config);
                }
            } else if (type == Integer.TYPE || type == Integer.class) {
                for (Object obj : collection) {
                    arrayCb.writeInt((Integer)obj);
                }
            } else if (type == Byte.TYPE || type == Byte.class) {
                for (Object obj : collection) {
                    arrayCb.writeByte(((Byte)obj).byteValue());
                }
            } else if (type == Long.TYPE || type == Long.class) {
                for (Object obj : collection) {
                    arrayCb.writeLong((Long)obj);
                }
            } else if (type == Short.TYPE || type == Short.class) {
                for (Object obj : collection) {
                    arrayCb.writeShort(((Short)obj).shortValue());
                }
            } else if (XLMessageStruct.class.isAssignableFrom(type)) {
                for (Object obj : collection) {
                    XLEncoderHelper.writeStruct((XLMessageStruct)obj, arrayCb, config);
                }
            } else if (Collection.class.isAssignableFrom(type)) {
                for (Object obj : collection) {
                    XLEncoderHelper.writeArray((Collection)obj, arrayCb, config);
                }
            }
            cb.writeBytes(arrayCb);
        }
    }

    public static void writeObject(Object obj, ChannelBuffer cb, XLStandardCodecConfig config) throws Exception {
        Field[] fieldArray = obj.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            XLEncoderHelper.writeObjectField(obj, cb, config, f);
            ++n2;
        }
    }

    private static void writeObjectField(Object obj, ChannelBuffer cb, XLStandardCodecConfig config, Field f) throws Exception {
        f.setAccessible(true);
        Object value = f.get(obj);
        Class<?> type = f.getType();
        if (type == String.class) {
            XLEncoderHelper.writeString(value.toString(), cb, config);
        } else if (type == Integer.TYPE || type == Integer.class) {
            cb.writeInt((Integer)value);
        } else if (type == Byte.TYPE || type == Byte.class) {
            cb.writeByte(((Byte)value).byteValue());
        } else if (type == Long.TYPE || type == Long.class) {
            cb.writeLong((Long)value);
        } else if (type == Short.TYPE || type == Short.class) {
            cb.writeShort(((Short)value).shortValue());
        } else if (XLMessageStruct.class.isAssignableFrom(type)) {
            XLEncoderHelper.writeStruct((XLMessageStruct)value, cb, config);
        } else if (Collection.class.isAssignableFrom(type)) {
            XLEncoderHelper.writeArray((Collection)value, cb, config);
        }
    }

    public static ChannelBuffer encode(XLMessage msg, XLStandardCodecConfig config) throws Exception {
        int contentLen;
        Field f;
        XLMessageHeader mh = msg.getXlMessageHeader();
        ByteOrder endian = config.getEndian();
        byte[] aesSecretKey = mh.getAesSecretKey();
        Field[] headerFields = mh.getClass().getDeclaredFields();
        ChannelBuffer content = ChannelBuffers.dynamicBuffer(endian, 256);
        int i = 0;
        int headerSplitIndex = headerFields.length;
        while (i < headerFields.length) {
            f = headerFields[i];
            if (f.getAnnotation(HeaderContentSplit.class) != null) {
                headerSplitIndex = i;
                break;
            }
            ++i;
        }
        while (i < headerFields.length) {
            f = headerFields[i];
            XLEncoderHelper.writeObjectField(mh, content, config, f);
            ++i;
        }
        XLEncoderHelper.writeObject(msg, content, config);
        int oriContentLen = contentLen = content.writerIndex();
        byte[] aesEncodeContent = null;
        byte[] oriContent = null;
        if (EmptyChecker.isNotEmpty(aesSecretKey)) {
            oriContent = Arrays.copyOf(content.array(), content.writerIndex());
            aesEncodeContent = AESCryptUtil.aesEncode(aesSecretKey, oriContent);
            contentLen = aesEncodeContent.length;
        }
        mh.setMessageLength(contentLen + config.getCommondHeaderLength());
        ChannelBuffer all = ChannelBuffers.dynamicBuffer(endian, 256);
        int j = 0;
        while (j < headerSplitIndex) {
            Field f2 = headerFields[j];
            XLEncoderHelper.writeObjectField(mh, all, config, f2);
            ++j;
        }
        if (aesEncodeContent == null) {
            all.writeBytes(content);
        } else {
            all.writeBytes(aesEncodeContent);
        }
        return all;
    }

    @Deprecated
    public static ChannelBuffer encode_bak(XLMessage msg, XLStandardCodecConfig config) throws Exception {
        ByteOrder endian = config.getEndian();
        ChannelBuffer content = ChannelBuffers.dynamicBuffer(endian, 256);
        XLEncoderHelper.writeObject(msg, content, config);
        int contentLen = content.writerIndex();
        XLMessageHeader mh = msg.getXlMessageHeader();
        mh.setMessageLength(contentLen + config.getCommondHeaderLength());
        ChannelBuffer all = ChannelBuffers.dynamicBuffer(endian, 256);
        XLEncoderHelper.writeObject(mh, all, config);
        all.writeBytes(content);
        return all;
    }

    public static byte[] encodeToBytes(XLMessage msg, XLStandardCodecConfig config) throws Exception {
        ChannelBuffer cb = XLEncoderHelper.encode(msg, config);
        return Arrays.copyOf(cb.array(), cb.writerIndex());
    }
}

