/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy.http;

import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import com.xunlei.util.XmlUtil;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.util.EntityUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserstatusProxy {
    private static final Logger log = Log.getLogger();
    @Autowired
    private HttpClient httpClient;
    @Config(value="userstatus.host")
    private String host;
    private int port;

    public String get_string(Collection<Long> uids) {
        URI uri = null;
        HttpGet httpGet = null;
        StringBuilder sb = new StringBuilder();
        if (uids != null) {
            try {
                sb.append("uid_list=");
                for (Long uid : uids) {
                    sb.append(uid).append(URLEncoder.encode("|", "UTF-8"));
                }
                if (uids.size() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.deleteCharAt(sb.length() - 1);
                    sb.deleteCharAt(sb.length() - 1);
                }
                uri = URIUtils.createURI("http", this.host, this.port, "/get", sb.toString(), null);
                log.debug("httpget url:{}", uri);
                httpGet = new HttpGet(uri);
                HttpResponse response = this.httpClient.execute(httpGet);
                HttpEntity entity = response.getEntity();
                String result = EntityUtils.toString(entity, "utf-8");
                return result;
            }
            catch (Exception e) {
                log.error("httpget -ERROR- " + uri, e);
            }
        }
        return null;
    }

    public UserStatusInfo get_vo(Collection<Long> uids) {
        String xmlResult = this.get_string(uids);
        if (StringTools.isEmpty(xmlResult)) {
            Element root = XmlUtil.getRootNode(xmlResult);
            UserStatusInfo info = new UserStatusInfo();
            try {
                info.setCode(Integer.parseInt(root.attributeValue("code")));
                ArrayList<UserStatusInfo.Node> nodes = new ArrayList<UserStatusInfo.Node>();
                if (info.getCode() == 0) {
                    UserStatusInfo.Node node = null;
                    Element e = root.element("online");
                    if (Integer.parseInt(e.attributeValue("number")) > 0) {
                        List<Element> elements = XmlUtil.parseXml(root, "online");
                        for (Element element : elements) {
                            UserStatusInfo userStatusInfo = info;
                            userStatusInfo.getClass();
                            node = userStatusInfo.new UserStatusInfo.Node(Long.parseLong(element.element("node").attributeValue("uid")), this.binaryString(Integer.parseInt(element.element("node").attributeValue("mask"))));
                            nodes.add(node);
                        }
                        info.setNodes(nodes);
                    }
                    return info;
                }
            }
            catch (Exception e) {
                log.error("", e);
            }
        }
        return null;
    }

    public Map<String, Boolean> compoundUserstatus(Collection<Long> uids) {
        String result = this.get_string(uids);
        if (StringTools.isEmpty(result)) {
            Element root = XmlUtil.getRootNode(result);
            if (root == null) {
                return null;
            }
            if (root.attribute("code").getText().equals("0")) {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                List<Element> nodes = XmlUtil.parseXml(root, "online");
                for (Element e : nodes) {
                    String uid = e.element("node").attribute("uid").getText();
                    String status = e.element("node").attribute("mask").getText();
                    String s = this.binaryString(Integer.parseInt(status));
                    if (s.substring(s.length() - 1, s.length()).equals("1")) {
                        map.put(uid, true);
                        continue;
                    }
                    map.put(uid, false);
                }
                return map;
            }
        }
        return null;
    }

    private String binaryString(int i) {
        String s = Integer.toBinaryString(i);
        StringBuilder sb = new StringBuilder();
        if (StringTools.isEmpty(s) && s.length() < 8) {
            int j = 0;
            while (j < 8 - s.length()) {
                sb.append("0");
                ++j;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public class UserStatusInfo {
        private int code;
        public List<Node> nodes;

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<Node> nodes) {
            this.nodes = nodes;
        }

        public class Node {
            private long uid;
            private String mask;

            public Node(long uid, String mask) {
                this.uid = uid;
                this.mask = mask;
            }

            public long getUid() {
                return this.uid;
            }

            public String getMask() {
                return this.mask;
            }

            public String toString() {
                return "uid : " + this.getUid() + ",mask : " + this.getMask();
            }
        }
    }
}

