/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.proxy;

import com.xunlei.proxy.ProxyFactory;
import com.xunlei.util.CharsetTools;
import com.xunlei.util.Log;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

public class HttpClientUtil {
    private static final HttpClient httpClient = ProxyFactory.getInstance().getHttpClient();
    private static final Logger log = Log.getLogger();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String httpGet(HttpClient httpClient, String url, String defaultCharset) {
        String string;
        HttpGet httpget = null;
        String result = null;
        try {
            httpget = new HttpGet(url);
            HttpResponse response = httpClient.execute(httpget);
            HttpEntity entity = response.getEntity();
            string = result = EntityUtils.toString(entity, defaultCharset);
        }
        catch (Exception e) {
            try {
                log.error("httpGet -ERROR- url:{}", new Object[]{url, e});
            }
            catch (Throwable throwable) {
                log.info("httpget url:{},result:{}", new Object[]{url, result});
                httpget.abort();
                throw throwable;
            }
            log.info("httpget url:{},result:{}", new Object[]{url, result});
            httpget.abort();
            return null;
        }
        log.info("httpget url:{},result:{}", new Object[]{url, result});
        httpget.abort();
        return string;
    }

    public static String httpGet(String url) {
        return HttpClientUtil.httpGet(url, CharsetTools.UTF_8.name());
    }

    public static String httpGet(String url, String defaultCharset) {
        return HttpClientUtil.httpGet(httpClient, url, defaultCharset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String httpPost(HttpClient httpClient, String url, String postContent, String defaultCharset) {
        String string;
        HttpPost httpPost = null;
        String content = null;
        try {
            httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(postContent, defaultCharset);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setEntity(entity);
            HttpResponse response = httpClient.execute(httpPost);
            string = content = EntityUtils.toString(response.getEntity(), defaultCharset);
        }
        catch (Exception e) {
            try {
                log.error("httpPost -ERROR- url:{},postContent:{}", new Object[]{url, postContent, e});
            }
            catch (Throwable throwable) {
                log.info("httpPost url:{},postContent:{},result:{}", new Object[]{url, postContent, content});
                httpPost.abort();
                throw throwable;
            }
            log.info("httpPost url:{},postContent:{},result:{}", new Object[]{url, postContent, content});
            httpPost.abort();
            return null;
        }
        log.info("httpPost url:{},postContent:{},result:{}", new Object[]{url, postContent, content});
        httpPost.abort();
        return string;
    }

    public static String httpPost(String url, String postContent) {
        return HttpClientUtil.httpPost(httpClient, url, postContent, CharsetTools.UTF_8.name());
    }

    public static String httpPost(String url, String postContent, String defaultCharset) {
        return HttpClientUtil.httpPost(httpClient, url, postContent, defaultCharset);
    }
}

