/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.easyutils.commonutils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static ThreadLocal timeThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };
    private static ThreadLocal dateThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };

    public static DateFormat getTimeFormat() {
        DateFormat df = (DateFormat)timeThreadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat(TIME_PATTERN);
            timeThreadLocal.set(df);
        }
        return df;
    }

    public static DateFormat getDateFormat() {
        DateFormat df = (DateFormat)dateThreadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat(DATE_PATTERN);
            dateThreadLocal.set(df);
        }
        return df;
    }

    public static String getOrderTime() {
        return DateUtil.getTimeFormat().format(new Date());
    }

    public static Date yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static String formatNow(String pattern) {
        return DateUtil.format(new Date(), pattern);
    }

    public static String formatNowByDefault() {
        return DateUtil.formatNow(TIME_PATTERN);
    }

    public static Date nextYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 1);
        return calendar.getTime();
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static long compareTime(String fromtime, String totime) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
        Date one = null;
        Date two = null;
        long days = 0L;
        try {
            one = df.parse(fromtime);
            two = df.parse(totime);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 - time2;
            days = diff / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static boolean isCurTimeInRange(String startTime, String endTime) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(TIME_PATTERN);
        return DateUtil.isCurTimeInRange(startTime, endTime, sdf);
    }

    private static boolean isCurTimeInRange(String startTime, String endTime, SimpleDateFormat sdf) throws Exception {
        Date startDate = sdf.parse(startTime);
        Date endDate = sdf.parse(endTime);
        Date nowDate = new Date();
        return nowDate.after(startDate) && endDate.after(nowDate);
    }

    public static String getNDaysLater(String time, int n) throws Exception {
        return DateUtil.calcDaysBeforeOrAfterNDays(time, n, 1);
    }

    public static String getNDaysLaterFromNow(int n) throws Exception {
        return DateUtil.getNDaysLater(DateUtil.formatNow(TIME_PATTERN), n);
    }

    public static String getNDaysBefore(String time, int n) throws Exception {
        return DateUtil.calcDaysBeforeOrAfterNDays(time, n, -1);
    }

    public static String getNDaysBeforeFromNow(int n) throws Exception {
        return DateUtil.getNDaysBefore(DateUtil.formatNow(TIME_PATTERN), n);
    }

    private static String calcDaysBeforeOrAfterNDays(String time, int n, int type) throws Exception {
        Date date = new SimpleDateFormat(TIME_PATTERN).parse(time);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, type == 1 ? n : -n);
        Date resultDate = calendar.getTime();
        return DateUtil.format(resultDate, TIME_PATTERN);
    }
}

