/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bt.bonus;

import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductCharge;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductGiveOutDayStatistics;
import com.xunlei.niux.data.vipgame.vo.boxThree.BoxBonusProductCharge;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class BonusProductBT {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void checkProductEnoughExchange(BonusProduct bonusProduct) {
        if (bonusProduct == null) {
            throw new NiuRuntimeException("1015", "\u4ea7\u54c1\u4e3a\u7a7a");
        }
        if (bonusProduct.getProductNum() < 1L) {
            throw new NiuRuntimeException("1017", "\u4ea7\u54c1\u6570\u91cf\u4e0d\u591f");
        }
        if (!"1".equals(bonusProduct.getProductStatus())) {
            throw new NiuRuntimeException("1016", "\u4ea7\u54c1\u4e0d\u53ef\u5151\u6362");
        }
        String now = sdf.format(new Date());
        if (StringUtils.isNotEmpty(bonusProduct.getValidPeriod()) && now.compareTo(bonusProduct.getValidPeriod()) > 0) {
            throw new NiuRuntimeException("1018", "\u4ea7\u54c1\u5151\u6362\u8fc7\u671f");
        }
    }

    public static void checkProductEnoughExchange(BonusProductCharge bonusProduct) {
        if (bonusProduct == null) {
            throw new NiuRuntimeException("1015", "\u4ea7\u54c1\u4e3a\u7a7a");
        }
        if (bonusProduct.getLeftCount() < 1L) {
            throw new NiuRuntimeException("1017", "\u4ea7\u54c1\u6570\u91cf\u4e0d\u591f");
        }
        if (!bonusProduct.getIsValid().booleanValue()) {
            throw new NiuRuntimeException("1016", "\u4ea7\u54c1\u4e0d\u53ef\u5151\u6362");
        }
    }

    public static void checkProductEnoughExchange(BoxBonusProductCharge bonusProduct) {
        if (bonusProduct == null) {
            throw new NiuRuntimeException("1015", "\u4ea7\u54c1\u4e3a\u7a7a");
        }
        if (bonusProduct.getLeftCount() < 1L) {
            throw new NiuRuntimeException("1017", "\u4ea7\u54c1\u6570\u91cf\u4e0d\u591f");
        }
        if (!bonusProduct.getIsValid().booleanValue()) {
            throw new NiuRuntimeException("1016", "\u4ea7\u54c1\u4e0d\u53ef\u5151\u6362");
        }
        String now = sdf.format(new Date());
        if (StringUtils.isNotEmpty(bonusProduct.getValdateTime().trim()) && now.compareTo(bonusProduct.getValdateTime()) > 0) {
            throw new NiuRuntimeException("1018", "\u4ea7\u54c1\u5151\u6362\u8fc7\u671f");
        }
    }

    public static void checkProductDayEnough(String productNo, String giveOutDate, Integer maxDayNum) {
        if (maxDayNum == null || maxDayNum <= 0) {
            return;
        }
        BonusProductGiveOutDayStatistics bpgods = FacadeFactory.INSTANCE.getBonusProductGiveOutDayStatisticsBo().find(productNo, giveOutDate);
        if (bpgods == null) {
            return;
        }
        if (maxDayNum < bpgods.getGiveOutSum() + 1) {
            throw new NiuRuntimeException("1019", "\u5df2\u8fbe\u5230\u6bcf\u65e5\u5151\u6362\u4e0a\u7ebf");
        }
    }

    public static BonusProduct checkProductEnoughExchange(String productNo) {
        BonusProduct product = new BonusProduct();
        product.setProductNo(productNo);
        List<BonusProduct> list = FacadeFactory.INSTANCE.getBonusProductBo().find(product, 1, 1);
        if (list == null || list.size() == 0) {
            throw new NiuRuntimeException("1015", "\u7269\u54c1\u4e0d\u5b58\u5728");
        }
        BonusProduct bonusProduct = list.get(0);
        BonusProductBT.checkProductEnoughExchange(bonusProduct);
        return bonusProduct;
    }
}

