/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vip.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vip.bo.UserRebateBo;
import com.xunlei.niux.data.vip.vo.UserRebateInfo;
import com.xunlei.niux.data.vip.vo.UserRebateRecord;
import com.xunlei.niux.data.vip.vo.UserRebateUseRecord;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRebateBoImpl
implements UserRebateBo {
    private static SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private BaseDao baseDao;

    @Override
    public UserRebateRecord addRebateRecord(UserRebateRecord p_record) {
        UserRebateInfo rebateInfo = this.findAndLockRebateInfo(p_record.getUserId());
        if (rebateInfo == null) {
            rebateInfo = new UserRebateInfo();
            rebateInfo.setUserId(p_record.getUserId());
            rebateInfo.setCanUseRebateSum(0);
            rebateInfo.setExpiredRebateSum(0);
            rebateInfo.setLatestRebateSum(0);
            rebateInfo.setRebateSum(0);
            rebateInfo.setUsedRebateSum(0);
            this.baseDao.insert(rebateInfo);
        }
        rebateInfo.setCanUseRebateSum(rebateInfo.getCanUseRebateSum() + p_record.getRebateMoney());
        rebateInfo.setLatestRebateSum(rebateInfo.getLatestRebateSum() + p_record.getRebateMoney());
        rebateInfo.setRebateSum(rebateInfo.getRebateSum() + p_record.getRebateMoney());
        this.baseDao.updateById(rebateInfo);
        Long now = System.currentTimeMillis();
        Long expireLong = now + 15552000000L;
        Date expireDate = new Date(expireLong);
        UserRebateRecord userRebateRecord = new UserRebateRecord();
        userRebateRecord.setUserId(p_record.getUserId());
        userRebateRecord.setGameId(p_record.getGameId());
        userRebateRecord.setExpireDate(sdfDate.format(expireDate));
        userRebateRecord.setJinKaVipLevel(p_record.getJinKaVipLevel());
        userRebateRecord.setPayOrderMoney(p_record.getPayOrderMoney());
        userRebateRecord.setPayOrderNo(p_record.getPayOrderNo());
        userRebateRecord.setRebateMoney(p_record.getRebateMoney());
        userRebateRecord.setRebateStatus(p_record.getRebateMoney() > 0 ? "WAITUSE" : "NOREBATE");
        userRebateRecord.setRecordTime(sdfTime.format(new Date(now)));
        userRebateRecord.setRoleId(p_record.getRoleId());
        userRebateRecord.setServerId(p_record.getServerId());
        userRebateRecord.setUseRecordNo("");
        userRebateRecord.setRebateNo(p_record.getRebateNo());
        userRebateRecord.setRoleName(p_record.getRoleName());
        userRebateRecord.setServerName(p_record.getServerName());
        this.baseDao.insert(userRebateRecord);
        return userRebateRecord;
    }

    @Override
    public UserRebateUseRecord addRebateUseRecord(UserRebateUseRecord p_useRecord, String[] rebateNos) {
        UserRebateInfo userRebateInfo = this.findAndLockRebateInfo(p_useRecord.getUserId());
        userRebateInfo.setCanUseRebateSum(userRebateInfo.getCanUseRebateSum() - p_useRecord.getUseMoney());
        userRebateInfo.setUsedRebateSum(userRebateInfo.getUsedRebateSum() + p_useRecord.getUseMoney());
        this.baseDao.updateById(userRebateInfo);
        UserRebateUseRecord useRebate = new UserRebateUseRecord();
        useRebate.setGameId(p_useRecord.getGameId());
        useRebate.setRoleId(p_useRecord.getRoleId());
        useRebate.setServerId(p_useRecord.getServerId());
        useRebate.setUseMoney(p_useRecord.getUseMoney());
        useRebate.setUserId(p_useRecord.getUserId());
        useRebate.setUseStatus("W");
        useRebate.setUseTime(sdfTime.format(new Date()));
        useRebate.setUseTimeStamp(0L);
        useRebate.setUseRecordNo(p_useRecord.getUseRecordNo());
        useRebate.setServerName(p_useRecord.getServerName());
        useRebate.setRoleName(p_useRecord.getRoleName());
        this.baseDao.insert(useRebate);
        for (String rebateNo : rebateNos) {
            if (rebateNo == null || "".equals(rebateNo)) continue;
            UserRebateRecord rebateRecord = this.baseDao.findById(UserRebateRecord.class, rebateNo);
            if (rebateRecord == null) {
                throw new RuntimeException("\u8fd4\u5229\u7f16\u53f7[" + rebateNo + "]\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8bb0\u5f55");
            }
            if (!rebateRecord.getRebateStatus().equals("WAITUSE")) {
                throw new RuntimeException("\u8fd4\u5229\u7f16\u53f7[" + rebateNo + "]\u8bb0\u5f55\u4e0d\u5c5e\u4e8e\u5f85\u4f7f\u7528");
            }
            if (rebateRecord.getExpireDate().compareTo(sdfDate.format(new Date())) < 0) {
                throw new RuntimeException("\u8fd4\u5229\u7f16\u53f7[" + rebateNo + "]\u8bb0\u5f55\u5df2\u7ecf\u5931\u6548");
            }
            rebateRecord.setRebateStatus("USED");
            rebateRecord.setUseRecordNo(useRebate.getUseRecordNo());
            this.baseDao.updateById(rebateRecord);
        }
        return p_useRecord;
    }

    @Override
    public UserRebateUseRecord updateRebateUseRecordTimestamp(String useRecordNo) {
        if (useRecordNo == null || useRecordNo.equals("")) {
            throw new NullPointerException("useRecordNo\u4e3a\u7a7a");
        }
        UserRebateUseRecord useRecord = this.findAndLockRebateUseRecord(useRecordNo);
        if (System.currentTimeMillis() - useRecord.getUseTimeStamp() < 2000L) {
            throw new RuntimeException("\u8bbf\u95ee\u592a\u9891\u7e41");
        }
        useRecord.setUseTimeStamp(System.currentTimeMillis());
        this.baseDao.updateById(useRecord);
        return useRecord;
    }

    private UserRebateUseRecord findAndLockRebateUseRecord(String useRecordNo) {
        if (useRecordNo == null || useRecordNo.equals("")) {
            throw new NullPointerException("useRecordNo\u4e3a\u7a7a");
        }
        String sql = "select * from user_rebate_userecord where useRecordNo=?";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(useRecordNo);
        List<UserRebateUseRecord> list = this.baseDao.executeQuery(UserRebateUseRecord.class, sql, paramList);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    private UserRebateInfo findAndLockRebateInfo(String userId) {
        if (userId == null || "".equals(userId)) {
            throw new NullPointerException("userId\u4e3a\u7a7a");
        }
        String sql = "select * from user_rebate_info where userId=?";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(userId);
        List<UserRebateInfo> list = this.baseDao.executeQuery(UserRebateInfo.class, sql, paramList);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public void updateRebateInfoLatestRebateSumZero(String userId) {
        UserRebateInfo rebateInfo = this.findAndLockRebateInfo(userId);
        rebateInfo.setLatestRebateSum(0);
        this.baseDao.updateById(rebateInfo);
    }

    @Override
    public void addHistoryRebate(String userId, int rebateMoney) {
        if (userId == null || "".equals(userId)) {
            throw new NullPointerException();
        }
        UserRebateRecord userRebateRecord = new UserRebateRecord();
        userRebateRecord.setUserId(userId);
        userRebateRecord.setGameId("");
        userRebateRecord.setExpireDate("2013-10-09");
        userRebateRecord.setJinKaVipLevel(0);
        userRebateRecord.setPayOrderMoney(rebateMoney);
        userRebateRecord.setPayOrderNo("payhis" + userId);
        userRebateRecord.setRebateMoney(rebateMoney);
        userRebateRecord.setRebateStatus("USED");
        userRebateRecord.setRecordTime("2013-10-10 12:00:00");
        userRebateRecord.setRoleId("");
        userRebateRecord.setServerId("");
        userRebateRecord.setUseRecordNo("");
        userRebateRecord.setRebateNo("rebatehis" + userId);
        userRebateRecord.setRoleName("");
        userRebateRecord.setServerName("");
        this.baseDao.insert(userRebateRecord);
        UserRebateInfo rebateInfo = this.findAndLockRebateInfo(userId);
        if (rebateInfo == null) {
            rebateInfo = new UserRebateInfo();
            rebateInfo.setUserId(userId);
            rebateInfo.setCanUseRebateSum(0);
            rebateInfo.setExpiredRebateSum(0);
            rebateInfo.setLatestRebateSum(0);
            rebateInfo.setRebateSum(0);
            rebateInfo.setUsedRebateSum(0);
            this.baseDao.insert(rebateInfo);
        }
        rebateInfo.setUsedRebateSum(rebateInfo.getUsedRebateSum() + rebateMoney);
        rebateInfo.setRebateSum(rebateInfo.getRebateSum() + rebateMoney);
        this.baseDao.updateById(rebateInfo);
    }

    @Override
    public void updateFailUseRecord(String userId, String useRecordNo) {
        if (useRecordNo == null || "".equals(useRecordNo) || userId == null || "".equals(userId)) {
            throw new NullPointerException();
        }
        UserRebateInfo userRebateInfo = this.findAndLockRebateInfo(userId);
        UserRebateUseRecord useRecord = this.baseDao.findById(UserRebateUseRecord.class, useRecordNo);
        if (!useRecord.getUseStatus().equals("F")) {
            throw new RuntimeException("\u8ba2\u5355[" + useRecordNo + "]\u7f16\u53f7\u975e\u6cd5");
        }
        if (!useRecord.getUserId().equals(userId)) {
            throw new RuntimeException("\u8ba2\u5355[" + useRecordNo + "]\u7528\u6237\u4e0d\u4e00\u81f4");
        }
        useRecord.setUseStatus("R");
        this.baseDao.updateById(useRecord);
        userRebateInfo.setCanUseRebateSum(userRebateInfo.getCanUseRebateSum() + useRecord.getUseMoney());
        userRebateInfo.setUsedRebateSum(userRebateInfo.getUsedRebateSum() - useRecord.getUseMoney());
        if (userRebateInfo.getUsedRebateSum() < 0) {
            throw new RuntimeException("\u7528\u6237[" + useRecord.getUserId() + "]\u5df2\u4f7f\u7528\u8fd4\u5229\u91d1\u989d[" + userRebateInfo.getUsedRebateSum() + "]\u975e\u6cd5");
        }
        if (userRebateInfo.getRebateSum() != userRebateInfo.getCanUseRebateSum() + userRebateInfo.getUsedRebateSum() + userRebateInfo.getExpiredRebateSum()) {
            throw new RuntimeException("\u7528\u6237[" + useRecord.getUserId() + "]\u603b\u8fd4\u5229\u4e0e\u5404\u660e\u7ec6\u4e0d\u4e00\u81f4");
        }
        this.baseDao.updateById(userRebateInfo);
        UserRebateRecord queryRecord = new UserRebateRecord();
        queryRecord.setUseRecordNo(useRecordNo);
        List<UserRebateRecord> recordList = this.baseDao.findByObject(UserRebateRecord.class, queryRecord, new Page());
        int money = 0;
        for (UserRebateRecord record : recordList) {
            money += record.getRebateMoney().intValue();
            if (!record.getUserId().equals(useRecord.getUserId())) {
                throw new RuntimeException("\u7528\u6237[" + useRecord.getUserId() + "]\u8fd4\u5229\u8bb0\u5f55[" + record.getRebateNo() + "]\u7528\u6237\u4e0d\u4e00\u81f4");
            }
            if (!record.getRebateStatus().equals("USED")) {
                throw new RuntimeException("\u7528\u6237[" + useRecord.getUserId() + "]\u8fd4\u5229\u8bb0\u5f55[" + record.getRebateNo() + "]\u4e0d\u5904\u4e8e\u4f7f\u7528\u9636\u6bb5");
            }
            if (!record.getUseRecordNo().equals(useRecordNo)) {
                throw new RuntimeException("\u975e\u6cd5\u4f7f\u7528\u7f16\u53f7");
            }
            record.setRebateStatus("WAITUSE");
            record.setUseRecordNo("");
            this.baseDao.updateById(record);
        }
        if (money != useRecord.getUseMoney()) {
            throw new RuntimeException("\u91d1\u989d\u4e0d\u7edf\u4e00");
        }
    }
}

