/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.manager.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.manager.bo.GameBo;
import com.xunlei.niux.data.manager.dao.GameDao;
import com.xunlei.niux.data.manager.vo.Game;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GameBoImpl
implements GameBo {
    private static SimpleDateFormat timeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private GameDao gameDao;

    public GameDao getGameDao() {
        return this.gameDao;
    }

    public void setGameDao(GameDao gameDao) {
        this.gameDao = gameDao;
    }

    @Override
    public Game queryGameById(String gameNo) {
        return this.gameDao.findObjectById(Game.class, gameNo);
    }

    @Override
    public Sheet<Game> queryGames(Game game, PagedFliper page) {
        return this.gameDao.queryGames(game, page);
    }

    @Override
    public void updateGame(Game game) throws Exception {
        this.setAddDefaultGame(game);
        this.checkGameParam(game);
        this.gameDao.updateObject(game);
    }

    @Override
    public Game addGame(Game game) throws Exception {
        this.setAddDefaultGame(game);
        this.checkGameParam(game);
        this.checkGameNoExisted(game.getGameNo());
        this.gameDao.insertObject(game);
        return game;
    }

    private void setAddDefaultGame(Game game) throws Exception {
        if (game == null) {
            throw new Exception("\u6e38\u620f\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(game.getOpenLinkType())) {
            game.setOpenLinkType("01");
        }
        Date t = new Date();
        String now = timeformat.format(t);
        game.setShowStatus("01");
        if (game.getShowEndDate() == null || "".equals(game.getShowEndDate())) {
            game.setShowEndDate(DatetimeUtil.addDate(game.getShowBeginDate(), "Y", 1));
        }
        game.setUpdateTime(now);
    }

    private void checkGameNoExisted(String gameNo) throws Exception {
        try {
            Game game = this.gameDao.findObjectById(Game.class, gameNo);
            if (game != null) {
                throw new Exception("\u6e38\u620f\u7f16\u53f7[" + gameNo + "]\u5df2\u5b58\u5728");
            }
        }
        catch (Exception e) {
            throw new Exception("\u9a8c\u8bc1\u6e38\u620f\u662f\u5426\u5b58\u5728\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private void checkGameParam(Game game) throws Exception {
        if (game == null) {
            throw new Exception("\u6e38\u620f\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(game.getGameNo())) {
            throw new Exception("\u6e38\u620f\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(game.getGameName())) {
            throw new Exception("\u6e38\u620f\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(game.getPicPath())) {
            throw new Exception("\u6d3b\u52a8\u56fe\u7247\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(game.getLinkPath())) {
            throw new Exception("\u94fe\u63a5\u5730\u5740\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(game.getOpenLinkType())) {
            throw new Exception("\u6253\u5f00\u94fe\u63a5\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(game.getShowStatus())) {
            throw new Exception("\u5e73\u53f0\u663e\u793a\u72b6\u6001\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(game.getShowBeginDate())) {
            throw new Exception("\u5e73\u53f0\u5f00\u59cb\u663e\u793a\u65e5\u671f\u4e3a\u7a7a");
        }
    }
}

