/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.manager.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.manager.bo.AdvertisementBo;
import com.xunlei.niux.data.manager.dao.AdvertisementDao;
import com.xunlei.niux.data.manager.vo.AdvSeat;
import com.xunlei.niux.data.manager.vo.Advertisement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdvertisementBoImpl
implements AdvertisementBo {
    private AdvertisementDao advertisementDao;
    private static final SimpleDateFormat timeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public AdvertisementDao getAdvertisementDao() {
        return this.advertisementDao;
    }

    public void setAdvertisementDao(AdvertisementDao advertisementDao) {
        this.advertisementDao = advertisementDao;
    }

    @Override
    public AdvSeat addAdvSeat(AdvSeat seat) throws Exception {
        this.setDefaultSeat(seat);
        this.checkAdvSeat(seat);
        this.checkSeatNoExisted(seat.getSeatNo());
        this.advertisementDao.insertObject(seat);
        return seat;
    }

    @Override
    public Advertisement addAdvs(Advertisement adv) throws Exception {
        this.setDefaultAdv(adv);
        this.validateAdvParam(adv);
        this.advertisementDao.insertObject(adv);
        return adv;
    }

    @Override
    public Sheet<Advertisement> queryAdv(Advertisement adv, PagedFliper page) {
        return this.advertisementDao.queryAdv(adv, page);
    }

    @Override
    public Advertisement queryAdvById(Long advNo) {
        return this.advertisementDao.findObjectById(Advertisement.class, advNo);
    }

    @Override
    public AdvSeat queryAdvSeatById(String seatNo) {
        return this.advertisementDao.findObjectById(AdvSeat.class, seatNo);
    }

    @Override
    public Sheet<AdvSeat> queryAdvSeats(AdvSeat seats, PagedFliper page) {
        return this.advertisementDao.queryAdvSeats(seats, page);
    }

    @Override
    public void updateAdv(Advertisement adv) throws Exception {
        this.setDefaultAdv(adv);
        this.validateAdvParam(adv);
        this.advertisementDao.updateObject(adv);
    }

    private void setDefaultAdv(Advertisement adv) {
        if (adv == null) {
            return;
        }
        if (StringTools.isEmpty(adv.getOpenLinkType())) {
            adv.setOpenLinkType("01");
        }
        Date t = new Date();
        String now = timeformat.format(t);
        adv.setShowStatus("01");
        if (adv.getShowEndDate() == null || "".equals(adv.getShowEndDate())) {
            adv.setShowEndDate(DatetimeUtil.addDate(adv.getShowBeginDate(), "Y", 1));
        }
        adv.setUpdateTime(now);
    }

    private void validateAdvParam(Advertisement adv) throws Exception {
        if (adv == null) {
            throw new Exception("\u5e7f\u544a\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(adv.getSeatNo())) {
            throw new Exception("\u5e7f\u544a\u4f4d\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(adv.getAdvTitle())) {
            throw new Exception("\u5e7f\u544a\u6807\u9898\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(adv.getBigPicPath())) {
            throw new Exception("\u5927\u56fe\u4e3a\u7a7a");
        }
        AdvSeat seat = this.advertisementDao.findObjectById(AdvSeat.class, adv.getSeatNo());
        if (seat == null) {
            throw new Exception("\u5e7f\u544a\u4f4d[" + adv.getSeatNo() + "\u4e0d\u5b58\u5728");
        }
        if ("1".equals(seat.getUploadSmallPic()) && StringTools.isEmpty(adv.getSmallPicPath())) {
            throw new Exception("\u5c0f\u56fe\u4e3a\u7a7a");
        }
    }

    @Override
    public void updateAdvSeat(AdvSeat seat) throws Exception {
        this.setDefaultSeat(seat);
        this.checkAdvSeat(seat);
        this.advertisementDao.updateObject(seat);
    }

    private void setDefaultSeat(AdvSeat seat) {
        if (seat == null) {
            return;
        }
        seat.setUpdateTime(timeformat.format(new Date()));
        if ("0".equals(seat.getUploadSmallPic())) {
            seat.setSmallPicResolution(null);
        }
    }

    private void checkSeatNoExisted(String seatNo) throws Exception {
        AdvSeat as = this.advertisementDao.findObjectById(AdvSeat.class, seatNo);
        if (as != null) {
            throw new Exception("\u7f16\u53f7[" + seatNo + "]\u5e7f\u544a\u4f4d\u5df2\u5b58\u5728");
        }
    }

    private void checkAdvSeat(AdvSeat seat) throws Exception {
        if (seat == null) {
            throw new Exception("\u5e7f\u544a\u4f4d\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(seat.getSeatNo())) {
            throw new Exception("\u5e7f\u544a\u4f4d\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(seat.getSeatName())) {
            throw new Exception("\u5e7f\u544a\u4f4d\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(seat.getAdvType())) {
            throw new Exception("\u5e7f\u544a\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (seat.getAdvTitleMaxSize() == null) {
            throw new Exception("\u5e7f\u544a\u6807\u9898\u6700\u957f\u957f\u5ea6\u4e3a\u7a7a");
        }
        if (seat.getAdvTitleMaxSize() < 0) {
            throw new Exception("\u5e7f\u544a\u6807\u9898\u6700\u957f\u957f\u5ea6\u4e3a\u8d1f\u6570");
        }
        if ("02".equals(seat.getAdvType())) {
            if (seat.getLoopTime() == null) {
                throw new Exception("\u8f6e\u64ad\u65f6\u95f4\u4e3a\u7a7a");
            }
            if (seat.getLoopTime() < 0) {
                throw new Exception("\u8f6e\u64ad\u65f6\u95f4\u4e3a\u8d1f\u6570");
            }
        }
        if (!AdvertisementBoImpl.validateResolutionFormat(seat.getBigPicResolution())) {
            throw new Exception("\u5927\u56fe\u5206\u8fa8\u7387\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if ("1".equals(seat.getUploadSmallPic()) && !AdvertisementBoImpl.validateResolutionFormat(seat.getSmallPicResolution())) {
            throw new Exception("\u5c0f\u56fe\u5206\u8fa8\u7387\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (StringTools.isEmpty(seat.getSeatStatus())) {
            throw new Exception("\u5e7f\u544a\u4f4d\u72b6\u6001\u4e3a\u7a7a");
        }
    }

    private static boolean validateResolutionFormat(String resolution) {
        if (StringTools.isEmpty(resolution)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[1-9][0-9]*\\*[1-9][0-9]*");
        Matcher matcher = pattern.matcher(resolution);
        return matcher.matches();
    }
}

