/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.manager.bo;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.manager.bo.ActivityBo;
import com.xunlei.niux.data.manager.dao.ActivityDao;
import com.xunlei.niux.data.manager.vo.Activity;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ActivityBoImpl
implements ActivityBo {
    private static SimpleDateFormat timeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ActivityDao activityDao;

    public ActivityDao getActivityDao() {
        return this.activityDao;
    }

    public void setActivityDao(ActivityDao activityDao) {
        this.activityDao = activityDao;
    }

    @Override
    public void updateActivity(Activity activity) throws Exception {
        this.setDefaultActivity(activity);
        this.checkActivityParam(activity);
        this.activityDao.updateObject(activity);
    }

    @Override
    public Activity addActivity(Activity activity) throws Exception {
        this.setDefaultActivity(activity);
        this.checkActivityParam(activity);
        this.checkActivityNoExisted(activity.getActNo());
        this.activityDao.insertObject(activity);
        return activity;
    }

    @Override
    public Activity queryActivityById(String actNo) {
        return this.activityDao.findObjectById(Activity.class, actNo);
    }

    @Override
    public Sheet<Activity> queryActivities(Activity activity, PagedFliper page) {
        return this.activityDao.queryActivities(activity, page);
    }

    private void setDefaultActivity(Activity activity) {
        if (activity == null) {
            return;
        }
        if (StringTools.isEmpty(activity.getOpenLinkType())) {
            activity.setOpenLinkType("01");
        }
        Date t = new Date();
        String now = timeformat.format(t);
        activity.setShowStatus("01");
        if (activity.getShowEndDate() == null || "".equals(activity.getShowEndDate())) {
            activity.setShowEndDate(DatetimeUtil.addDate(activity.getShowBeginDate(), "Y", 1));
        }
        if (activity.getActEndDate() == null || "".equals(activity.getActEndDate())) {
            activity.setActEndDate(DatetimeUtil.addDate(activity.getActBeginDate(), "Y", 1));
        }
        activity.setUpdateTime(now);
    }

    private void checkActivityNoExisted(String actNo) throws Exception {
        Activity vo = null;
        try {
            vo = this.activityDao.findObjectById(Activity.class, actNo);
        }
        catch (Exception e) {
            throw new Exception("\u9a8c\u8bc1\u6d3b\u52a8\u7f16\u53f7\u662f\u5426\u5b58\u5728\u51fa\u73b0\u5f02\u5e38", e);
        }
        if (vo != null) {
            throw new Exception("\u6d3b\u52a8\u7f16\u53f7[" + actNo + "]\u5df2\u5b58\u5728");
        }
    }

    private void checkActivityParam(Activity activity) throws Exception {
        if (activity == null) {
            throw new Exception("\u4e13\u9898\u6d3b\u52a8\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(activity.getActNo())) {
            throw new Exception("\u6d3b\u52a8\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(activity.getActName())) {
            throw new Exception("\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(activity.getParticipator())) {
            throw new Exception("\u6d3b\u52a8\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(activity.getActBeginDate())) {
            throw new Exception("\u6d3b\u52a8\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(activity.getPicPath())) {
            throw new Exception("\u6d3b\u52a8\u56fe\u7247\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(activity.getLinkPath())) {
            throw new Exception("\u8fde\u63a5\u5730\u5740\u4e3a\u7a7a");
        }
        if (StringTools.isEmpty(activity.getHomePageShow())) {
            throw new Exception("\u63a8\u8350\u5230\u9996\u9875\u4e3a\u7a7a");
        }
    }
}

