/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.league.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.league.bo.PromoterProfitSo;
import com.xunlei.niux.data.league.vo.PromoterProfitRate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PromoterProfitSoImpl
implements PromoterProfitSo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    @Override
    public List<PromoterProfitRate> finds(PromoterProfitRate query, Page page) {
        return this.baseDao.findByObject(PromoterProfitRate.class, query, page);
    }

    @Override
    public void add(List<PromoterProfitRate> list) {
        this.checkPromoterProfitRateValid(list);
        PromoterProfitRate p1 = list.get(0);
        PromoterProfitRate query = new PromoterProfitRate();
        query.setPromoterAccount(p1.getPromoterAccount());
        query.setRateType(p1.getRateType());
        List<PromoterProfitRate> oldList = this.finds(query, new Page());
        if (oldList != null) {
            this.delete(oldList);
        }
        for (PromoterProfitRate ppr : list) {
            this.baseDao.insert(ppr);
        }
    }

    public void delete(List<PromoterProfitRate> list) {
        for (PromoterProfitRate ppr : list) {
            this.delete(ppr.getSeqId());
        }
    }

    public void delete(long seqId) {
        this.baseDao.deleteById(PromoterProfitRate.class, seqId);
    }

    private void checkPromoterProfitRateValid(List<PromoterProfitRate> list) {
        Integer minKey;
        Integer max;
        PromoterProfitRate p1 = list.get(0);
        if (p1.getPromoterAccount() == null || p1.getPromoterAccount().equals("")) {
            throw new RuntimeException("\u63a8\u5e7f\u5458\u8d26\u53f7\u4e3a\u7a7a");
        }
        if (p1.getRateType() == null || "".equals(p1.getRateType())) {
            throw new RuntimeException("\u63a8\u5e7f\u5458\u8d26\u53f7");
        }
        boolean isIncrementArea = p1.getIsIncrementArea();
        HashSet<Integer> max_set = new HashSet<Integer>();
        HashMap<Integer, Integer> min_max_map = new HashMap<Integer, Integer>();
        for (PromoterProfitRate ppr : list) {
            if (ppr.getMaxMoney() != null && ppr.getMaxMoney() <= ppr.getMinMoney()) {
                throw new RuntimeException("\u5b58\u5728\u8d77\u59cb\u91d1\u989d\u5927\u4e8e\u7b49\u4e8e\u7ed3\u675f\u91d1\u989d\u7684\u533a\u95f4");
            }
            if (isIncrementArea != ppr.getIsIncrementArea()) {
                throw new RuntimeException("\u5b58\u5728\u591a\u79cd\u533a\u95f4\u60c5\u51b5");
            }
            if (!p1.getPromoterAccount().equals(ppr.getPromoterAccount())) {
                throw new RuntimeException("\u4e00\u6b21\u5b9a\u4e49\u591a\u4e2a\u63a8\u5e7f\u5458");
            }
            if (ppr.getRate() >= 1.0) {
                throw new RuntimeException("\u975e\u6cd5\u6bd4\u7387");
            }
            min_max_map.put(ppr.getMinMoney(), ppr.getMaxMoney());
            max_set.add(ppr.getMaxMoney());
        }
        if (!min_max_map.containsKey(0)) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u8d77\u59cb\u91d1\u989d\u4e3a0\u7684\u533a\u95f4");
        }
        if (!max_set.contains(null)) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u7ed3\u675f\u91d1\u989d\u4e3a\u65e0\u7a77\u5927\u7684\u533a\u95f4");
        }
        if (max_set.size() != list.size()) {
            throw new RuntimeException("\u5b58\u5728\u7ed3\u675f\u91d1\u989d\u76f8\u540c\u7684\u533a\u95f4");
        }
        if (!isIncrementArea) {
            if (min_max_map.size() > 1) {
                throw new RuntimeException("\u5b58\u5728\u8d77\u59cb\u91d1\u989d\u4e0d\u4e3a0\u7684\u533a\u95f4");
            }
            return;
        }
        if (min_max_map.size() < max_set.size()) {
            throw new RuntimeException("\u5b58\u5728\u8d77\u59cb\u91d1\u989d\u91cd\u590d\u7684\u533a\u95f4");
        }
        Set keySet = min_max_map.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext() && (max = (Integer)min_max_map.get(minKey = (Integer)it.next())) != null) {
            if (min_max_map.containsKey(max)) continue;
            throw new RuntimeException("\u533a\u95f4\u8bbe\u7f6e\u4e0d\u8fde\u8d2f");
        }
    }

    public static void main(String[] args) {
        ArrayList<PromoterProfitRate> list = new ArrayList<PromoterProfitRate>();
        PromoterProfitRate pp1 = new PromoterProfitRate();
        pp1.setIsIncrementArea(true);
        pp1.setMinMoney(0);
        pp1.setMaxMoney(100);
        list.add(pp1);
        PromoterProfitRate pp2 = new PromoterProfitRate();
        pp2.setIsIncrementArea(true);
        pp2.setMinMoney(100);
        pp2.setMaxMoney(10000);
        list.add(pp2);
        PromoterProfitRate pp3 = new PromoterProfitRate();
        pp3.setIsIncrementArea(true);
        pp3.setMinMoney(10000);
        pp3.setMaxMoney(100000);
        list.add(pp3);
        PromoterProfitSoImpl t = new PromoterProfitSoImpl();
        t.checkPromoterProfitRateValid(list);
    }
}

