/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.jinzuanbiz.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.jinzuanbiz.dao.GameFirstPayDao;
import com.xunlei.niux.data.jinzuanbiz.dto.GameRankingDTO;
import com.xunlei.niux.data.jinzuanbiz.enums.TimePeriodEnum;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

public class GameFirstPayDaoImpl
extends BaseDaoImpl
implements GameFirstPayDao {
    private static DateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public List<GameRankingDTO> getGameFirstPayGameRankingList(int limit) {
        String sql = "select gameid,count(gameId) as totalCount from jinzuan_gamefirstpay group by gameid order by totalCount desc limit ?";
        final ArrayList<GameRankingDTO> list = new ArrayList<GameRankingDTO>();
        this.getJdbcTemplate().query(sql, new Object[]{limit}, new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                GameRankingDTO gameRankingDTO = new GameRankingDTO();
                gameRankingDTO.setGameId(resultSet.getString("gameid"));
                gameRankingDTO.setTotalCount(resultSet.getInt("totalCount"));
                list.add(gameRankingDTO);
            }
        });
        return list;
    }

    @Override
    public int getTotalFirstPayMoney(TimePeriodEnum timePeriodEnum) {
        String date = sdf_date.format(new Date());
        String sql = "select count(money) as total from jinzuan_gamefirstpay where date(recordTime) = ?";
        int total = this.getJdbcTemplate().queryForInt(sql, new Object[]{date});
        if (total <= 0) {
            return 0;
        }
        return total;
    }
}

