/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.jinzuanbiz.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.jinzuanbiz.dao.BonusExchangeCoinDao;
import com.xunlei.niux.data.jinzuanbiz.dto.GameRankingDTO;
import com.xunlei.niux.data.jinzuanbiz.enums.TimePeriodEnum;
import com.xunlei.niux.data.jinzuanbiz.vo.BonusExchangeCoin;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

public class BonusExchangeCoinDaoImpl
extends BaseDaoImpl
implements BonusExchangeCoinDao {
    private static DateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public List<GameRankingDTO> getBonusExchangeCoinGameRankingList(int limit) {
        String sql = "select gameid,count(gameId) as totalCount from jinzuan_bonusexchangecoin group by gameid order by totalCount desc limit ? ";
        final ArrayList<GameRankingDTO> list = new ArrayList<GameRankingDTO>();
        this.getJdbcTemplate().query(sql, new Object[]{limit}, new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                GameRankingDTO gameRankingDTO = new GameRankingDTO();
                gameRankingDTO.setGameId(resultSet.getString("gameid"));
                gameRankingDTO.setTotalCount(resultSet.getInt("totalCount"));
                list.add(gameRankingDTO);
            }
        });
        return list;
    }

    @Override
    public List<BonusExchangeCoin> getUnSuccessExchangeRecord() {
        String sql = "select seqId,userId,consumeBonusPoint,gameId,serverId,roleId,exchangeMoney,status,recordTime from jinzuan_bonusexchangecoin where status != 3;";
        final ArrayList<BonusExchangeCoin> list = new ArrayList<BonusExchangeCoin>();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                BonusExchangeCoin bonusExchangeCoin = new BonusExchangeCoin();
                bonusExchangeCoin.setSeqId(resultSet.getLong("seqId"));
                bonusExchangeCoin.setUserId(resultSet.getLong("userId"));
                bonusExchangeCoin.setConsumeBonusPoint(resultSet.getInt("consumeBonusPoint"));
                bonusExchangeCoin.setGameId(resultSet.getString("gameId"));
                bonusExchangeCoin.setServerId(resultSet.getString("serverId"));
                bonusExchangeCoin.setRoleId(resultSet.getString("roleId"));
                bonusExchangeCoin.setExchangeMoney(resultSet.getInt("exchangeMoney"));
                bonusExchangeCoin.setStatus(resultSet.getInt("status"));
                bonusExchangeCoin.setRecordTime(resultSet.getString("recordTime"));
                list.add(bonusExchangeCoin);
            }
        });
        return list;
    }

    @Override
    public int getTotalExchangeMoney(TimePeriodEnum timePeriodEnum) {
        String date = sdf_date.format(new Date());
        String sql = "select count(exchangeMoney) as total from jinzuan_bonusexchangecoin where date(recordTime) = ?";
        int total = this.getJdbcTemplate().queryForInt(sql, new Object[]{date});
        if (total <= 0) {
            return 0;
        }
        return total;
    }
}

